/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui.buttons;

import appeng.api.config.SortOrder;
import appeng.core.localization.ButtonToolTips;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import thaumicenergistics.client.gui.buttons.ThEStateButton;
import thaumicenergistics.client.textures.AEStateIconsEnum;
import thaumicenergistics.common.storage.AspectStackComparator;

@SideOnly(value=Side.CLIENT)
public class GuiButtonSortingMode
extends ThEStateButton {
    private String tooltipSortBy = "";

    public GuiButtonSortingMode(int ID, int xPosition, int yPosition, int width, int height) {
        super(ID, xPosition, yPosition, width, height, AEStateIconsEnum.SORT_MODE_ALPHABETIC, 0, 0, AEStateIconsEnum.REGULAR_BUTTON);
    }

    @Override
    public void getTooltip(List<String> tooltip) {
        this.addAboutToTooltip(tooltip, ButtonToolTips.SortBy.getLocal(), EnumChatFormatting.GRAY + this.tooltipSortBy);
    }

    public void setSortMode(AspectStackComparator.AspectStackComparatorMode mode) {
        switch (mode) {
            case MODE_ALPHABETIC: {
                this.stateIcon = AEStateIconsEnum.SORT_MODE_ALPHABETIC;
                this.tooltipSortBy = ButtonToolTips.ItemName.getLocal();
                break;
            }
            case MODE_AMOUNT: {
                this.stateIcon = AEStateIconsEnum.SORT_MODE_AMOUNT;
                this.tooltipSortBy = ButtonToolTips.NumberOfItems.getLocal();
            }
        }
    }

    public void setSortMode(SortOrder order) {
        switch (order) {
            case AMOUNT: {
                this.stateIcon = AEStateIconsEnum.SORT_MODE_AMOUNT;
                this.tooltipSortBy = StatCollector.func_74838_a((String)"gui.tooltips.appliedenergistics2.NumberOfItems");
                break;
            }
            case INVTWEAKS: {
                this.stateIcon = AEStateIconsEnum.SORT_MODE_INVTWEAK;
                this.tooltipSortBy = StatCollector.func_74838_a((String)"gui.tooltips.appliedenergistics2.InventoryTweaks");
                break;
            }
            case MOD: {
                this.stateIcon = AEStateIconsEnum.SORT_MODE_MOD;
                this.tooltipSortBy = StatCollector.func_74838_a((String)"gui.tooltips.appliedenergistics2.Mod");
                break;
            }
            case NAME: {
                this.stateIcon = AEStateIconsEnum.SORT_MODE_ALPHABETIC;
                this.tooltipSortBy = StatCollector.func_74838_a((String)"gui.tooltips.appliedenergistics2.ItemName");
            }
        }
    }
}

