/*
 * Decompiled with CFR 0.152.
 */
package vswe.production.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import vswe.production.StevesProduction;
import vswe.production.network.IBitCount;
import vswe.production.network.StandardCounts;

public class DataWriter {
    private ByteBuf stream = Unpooled.buffer();
    private int byteBuffer;
    private int bitCountBuffer;

    DataWriter() {
    }

    public void writeData(int data, IBitCount bitCount) {
        this.writeData(data, bitCount.getBitCount());
    }

    private void writeData(int data, int bitCount) {
        long mask = (long)Math.pow(2.0, bitCount) - 1L;
        data = (int)((long)data & mask);
        while (this.bitCountBuffer + bitCount >= 8) {
            int bitsToAdd = 8 - this.bitCountBuffer;
            int addMask = (int)Math.pow(2.0, bitsToAdd) - 1;
            int addData = data & addMask;
            data >>>= bitsToAdd;
            this.byteBuffer |= (addData <<= this.bitCountBuffer);
            this.stream.writeByte(this.byteBuffer);
            this.byteBuffer = 0;
            bitCount -= bitsToAdd;
            this.bitCountBuffer = 0;
        }
        this.byteBuffer |= data << this.bitCountBuffer;
        this.bitCountBuffer += bitCount;
    }

    public void writeString(String str) {
        this.writeString(str, StandardCounts.DEFAULT_STRING);
    }

    public void writeString(String str, IBitCount bits) {
        if (str != null) {
            byte[] bytes = str.getBytes();
            int l = Math.min(bytes.length, (int)Math.pow(2.0, bits.getBitCount()) - 1);
            this.writeData(l, bits);
            for (int i = 0; i < l; ++i) {
                this.writeByte(bytes[i]);
            }
        } else {
            this.writeData(0, bits);
        }
    }

    public void writeNBT(NBTTagCompound nbtTagCompound) {
        byte[] bytes = null;
        if (nbtTagCompound != null) {
            try {
                bytes = CompressedStreamTools.func_74798_a((NBTTagCompound)nbtTagCompound);
            }
            catch (IOException ex) {
                bytes = null;
            }
        }
        this.writeBoolean(bytes != null);
        if (bytes != null) {
            this.writeData(bytes.length, StandardCounts.NBT_LENGTH);
            for (byte b : bytes) {
                this.writeByte(b);
            }
        }
    }

    void writeFinalBits() {
        if (this.bitCountBuffer > 0) {
            this.stream.writeByte(this.byteBuffer);
            this.bitCountBuffer = 0;
        }
    }

    private FMLProxyPacket createPacket() {
        this.writeFinalBits();
        return new FMLProxyPacket(this.stream, "SWorkshop");
    }

    void sendToPlayer(EntityPlayerMP player) {
        StevesProduction.packetHandler.sendTo(this.createPacket(), player);
    }

    void sendToServer() {
        StevesProduction.packetHandler.sendToServer(this.createPacket());
    }

    void sendToAllPlayers() {
        StevesProduction.packetHandler.sendToAll(this.createPacket());
    }

    void sendToAllPlayersAround(TileEntity te, double range) {
        this.sendToAllPlayersAround(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e, range);
    }

    void sendToAllPlayersAround(World world, int x, int y, int z, double range) {
        StevesProduction.packetHandler.sendToAllAround(this.createPacket(), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x + 0.5, (double)y + 0.5, (double)z, range));
    }

    public void writeBoolean(boolean data) {
        this.writeData(data ? 1 : 0, StandardCounts.BOOLEAN);
    }

    public void writeByte(int data) {
        this.writeData(data, StandardCounts.BYTE);
    }

    public void writeShort(int data) {
        this.writeData(data, StandardCounts.SHORT);
    }

    public void writeInteger(int data) {
        this.writeData(data, StandardCounts.INTEGER);
    }

    public void writeEnum(Enum data) {
        try {
            Class clazz = data.getDeclaringClass();
            int length = ((Object[])clazz.getMethod("values", new Class[0]).invoke(null, new Object[0])).length;
            if (length == 0) {
                return;
            }
            int bitCount = (int)(Math.log10(length) / Math.log10(2.0)) + 1;
            this.writeData(data.ordinal(), bitCount);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

