/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.launchertray;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.win32.W32APIOptions;
import cpw.mods.fml.common.ProgressManager;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.creeperhost.launchertray.HookLoader;
import net.creeperhost.launchertray.LauncherTray;
import org.lwjgl.opengl.Display;

public class OurFunctions {
    private static MethodHandle displayHandle;
    static boolean hidden;
    private static long hwndCache;

    public static boolean init() {
        LauncherTray.sendInit();
        return true;
    }

    public static void step() {
        if (HookLoader.instanceID.isEmpty() && LauncherTray.instanceUUID != null && !hidden) {
            OurFunctions.hideWindow();
            hidden = true;
        }
        LauncherTray.sendProgress(ProgressManager.barIterator());
    }

    public static void done() {
        if (HookLoader.instanceID.isEmpty() && LauncherTray.instanceUUID != null) {
            OurFunctions.showWindow();
        }
        LauncherTray.sendDone();
    }

    public static void hideWindow() {
        OurFunctions.changeWindow(true);
    }

    public static void showWindow() {
        OurFunctions.changeWindow(false);
    }

    public static void changeWindow(boolean hide) {
        if (!OurFunctions.isReady()) {
            return;
        }
        long hwndLong = OurFunctions.getHwndLong();
        WinDef.HWND hwnd = new WinDef.HWND(new Pointer(hwndLong));
        if (OurUser32.INSTANCE.IsWindow(hwnd)) {
            User32.INSTANCE.ShowWindow(hwnd, hide ? 0 : 5);
            User32.INSTANCE.SetFocus(hwnd);
        }
    }

    private static Object getDisplayImplementation() {
        try {
            Object implementation = displayHandle.invoke();
            if (implementation.getClass().getCanonicalName().equals("org.lwjgl.opengl.WindowsDisplay")) {
                return implementation;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    private static long getHwndLong() {
        if (!OurFunctions.isReady()) {
            return -1L;
        }
        if (hwndCache != -1L) {
            return hwndCache;
        }
        Object displayImplementation = OurFunctions.getDisplayImplementation();
        if (displayImplementation == null) {
            return -1L;
        }
        try {
            Field hwnd = displayImplementation.getClass().getDeclaredField("hwnd");
            hwnd.setAccessible(true);
            hwndCache = hwnd.getLong(displayImplementation);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        return hwndCache;
    }

    public static void kill() {
        try {
            Class<?> aClass = Class.forName("net.minecraft.client.Minecraft");
            Method shutdownMC = aClass.getDeclaredMethod(LauncherTray.getName("shutdown", "func_71400_g"), new Class[0]);
            Method getMinecraft = aClass.getDeclaredMethod(LauncherTray.getName("getMinecraft", "func_71410_x"), new Class[0]);
            Object invoke = getMinecraft.invoke(null, new Object[0]);
            OurFunctions.done();
            shutdownMC.invoke(invoke, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static boolean isReady() {
        return displayHandle != null;
    }

    static {
        if (HookLoader.instanceID.isEmpty() && LauncherTray.instanceUUID != null) {
            try {
                Method getImplementation = Display.class.getDeclaredMethod("getImplementation", new Class[0]);
                getImplementation.setAccessible(true);
                displayHandle = MethodHandles.lookup().unreflect(getImplementation);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        hidden = false;
        hwndCache = -1L;
    }

    public static interface OurUser32
    extends User32 {
        public static final OurUser32 INSTANCE = Native.loadLibrary("user32", OurUser32.class, W32APIOptions.DEFAULT_OPTIONS);

        @Override
        public boolean IsWindow(WinDef.HWND var1);
    }
}

