/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm;

import com.enderio.core.common.util.BlockCoord;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.ContinuousTask;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.farm.FakeFarmPlayer;
import crazypants.enderio.machine.farm.Fertilizer;
import crazypants.enderio.machine.farm.PacketFarmAction;
import crazypants.enderio.machine.farm.PacketFarmLockedSlot;
import crazypants.enderio.machine.farm.PacketUpdateNotification;
import crazypants.enderio.machine.farm.farmers.FarmersCommune;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import crazypants.enderio.machine.farm.farmers.RubberTreeFarmerIC2;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.tool.ArrayMappingTool;
import java.util.BitSet;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileFarmStation
extends AbstractPoweredTaskEntity {
    private static final int TICKS_PER_WORK = 20;
    public static final String NOTIFICATION_NO_HOE = "noHoe";
    public static final String NOTIFICATION_NO_AXE = "noAxe";
    public static final String NOTIFICATION_NO_SEEDS = "noSeeds";
    private BlockCoord lastScanned;
    private EntityPlayerMP farmerJoe;
    public static final int NUM_TOOL_SLOTS = 3;
    private static final int minToolSlot = 0;
    private static final int maxToolSlot = 2;
    public static final int NUM_FERTILIZER_SLOTS = 2;
    public static final int minFirtSlot = 3;
    public static final int maxFirtSlot = 4;
    public static final int NUM_SUPPLY_SLOTS = 4;
    public static final int minSupSlot = 5;
    public static final int maxSupSlot = 8;
    private final BitSet lockedSlots = new BitSet();
    public String notification = "";
    public boolean sendNotification = false;
    private boolean wasActive;
    private int bonemealCooldown = 5;

    public TileFarmStation() {
        super(new SlotDefinition(9, 6, 1));
    }

    public int getFarmSize() {
        return Config.farmDefaultSize + this.getUpgradeDist();
    }

    public void actionPerformed(boolean isAxe) {
        if (isAxe) {
            this.usePower(Config.farmAxeActionEnergyUseRF);
        } else {
            this.usePower(Config.farmActionEnergyUseRF);
        }
        this.clearNotification();
    }

    public boolean tillBlock(BlockCoord plantingLocation) {
        BlockCoord dirtLoc = plantingLocation.getLocation(ForgeDirection.DOWN);
        Block dirtBlock = this.getBlock(dirtLoc);
        if (dirtBlock == Blocks.field_150346_d || dirtBlock == Blocks.field_150349_c) {
            if (!this.hasHoe()) {
                this.setNotification(NOTIFICATION_NO_HOE);
                return false;
            }
            this.damageHoe(1, dirtLoc);
            this.field_145850_b.func_147449_b(dirtLoc.x, dirtLoc.y, dirtLoc.z, Blocks.field_150458_ak);
            this.field_145850_b.func_72908_a((double)((float)dirtLoc.x + 0.5f), (double)((float)dirtLoc.y + 0.5f), (double)((float)dirtLoc.z + 0.5f), Blocks.field_150458_ak.field_149762_H.func_150498_e(), (Blocks.field_150458_ak.field_149762_H.func_150497_c() + 1.0f) / 2.0f, Blocks.field_150458_ak.field_149762_H.func_150494_d() * 0.8f);
            this.actionPerformed(false);
            return true;
        }
        return dirtBlock == Blocks.field_150458_ak;
    }

    public int getMaxLootingValue() {
        int result = 0;
        for (int i = 0; i <= 2; ++i) {
            int level;
            if (this.inventory[i] == null || (level = this.getLooting(this.inventory[i])) <= result) continue;
            result = level;
        }
        return result;
    }

    private int getUpgradeDist() {
        int upg = this.slotDefinition.getMaxUpgradeSlot();
        if (this.inventory[upg] == null) {
            return 0;
        }
        return Config.farmBonusSize * this.inventory[upg].func_77960_j();
    }

    public boolean hasHoe() {
        return this.hasTool(ToolType.HOE);
    }

    public boolean hasAxe() {
        return this.hasTool(ToolType.AXE);
    }

    public boolean hasShears() {
        return this.hasTool(ToolType.SHEARS);
    }

    public int getAxeLootingValue() {
        ItemStack tool = this.getTool(ToolType.AXE);
        if (tool == null) {
            return 0;
        }
        return this.getLooting(tool);
    }

    public void damageAxe(Block blk, BlockCoord bc) {
        this.damageTool(ToolType.AXE, blk, bc, 1);
    }

    public void damageHoe(int i, BlockCoord bc) {
        this.damageTool(ToolType.HOE, null, bc, i);
    }

    public void damageShears(Block blk, BlockCoord bc) {
        this.damageTool(ToolType.SHEARS, blk, bc, 1);
    }

    public boolean hasTool(ToolType type) {
        return this.getTool(type) != null;
    }

    private ItemStack getTool(ToolType type) {
        for (int i = 0; i <= 2; ++i) {
            if (!type.itemMatches(this.inventory[i]) || this.inventory[i].field_77994_a <= 0) continue;
            return this.inventory[i];
        }
        return null;
    }

    public void damageTool(ToolType type, Block blk, BlockCoord bc, int damage) {
        ItemStack tool = this.getTool(type);
        if (tool == null) {
            return;
        }
        float rand = this.field_145850_b.field_73012_v.nextFloat();
        if (rand >= Config.farmToolTakeDamageChance) {
            return;
        }
        boolean canDamage = this.canDamage(tool);
        if (type == ToolType.AXE) {
            tool.func_77973_b().func_150894_a(tool, this.field_145850_b, blk, bc.x, bc.y, bc.z, (EntityLivingBase)this.farmerJoe);
        } else if (type == ToolType.HOE) {
            int origDamage = tool.func_77960_j();
            tool.func_77973_b().func_77648_a(tool, (EntityPlayer)this.farmerJoe, this.field_145850_b, bc.x, bc.y, bc.z, 1, 0.5f, 0.5f, 0.5f);
            if (origDamage == tool.func_77960_j() && canDamage) {
                tool.func_77972_a(1, (EntityLivingBase)this.farmerJoe);
            }
        } else if (canDamage) {
            tool.func_77972_a(1, (EntityLivingBase)this.farmerJoe);
        }
        if (tool.field_77994_a == 0 || canDamage && tool.func_77960_j() >= tool.func_77958_k()) {
            this.destroyTool(type);
        }
    }

    private boolean canDamage(ItemStack stack) {
        return stack != null && stack.func_77984_f() && stack.func_77973_b().func_77645_m();
    }

    private void destroyTool(ToolType type) {
        for (int i = 0; i <= 2; ++i) {
            if (!type.itemMatches(this.inventory[i]) || this.inventory[i].field_77994_a != 0) continue;
            this.inventory[i] = null;
            this.func_70296_d();
            return;
        }
    }

    private int getLooting(ItemStack stack) {
        return Math.max(EnchantmentHelper.func_77506_a((int)Enchantment.field_77335_o.field_77352_x, (ItemStack)stack), EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack));
    }

    public EntityPlayerMP getFakePlayer() {
        return this.farmerJoe;
    }

    public Block getBlock(BlockCoord bc) {
        return this.field_145850_b.func_147439_a(bc.x, bc.y, bc.z);
    }

    public Block getBlock(int x, int y, int z) {
        return this.field_145850_b.func_147439_a(x, y, z);
    }

    public int getBlockMeta(BlockCoord bc) {
        return this.field_145850_b.func_72805_g(bc.x, bc.y, bc.z);
    }

    public boolean isOpen(BlockCoord bc) {
        Block block = this.field_145850_b.func_147439_a(bc.x, bc.y, bc.z);
        return block.isAir((IBlockAccess)this.field_145850_b, bc.x, bc.y, bc.z) || block.isReplaceable((IBlockAccess)this.field_145850_b, bc.x, bc.y, bc.z);
    }

    public void setNotification(String unloc) {
        String newNote = EnderIO.lang.localize("farm.note." + unloc);
        if (!newNote.equals(this.notification)) {
            this.notification = newNote;
            this.sendNotification = true;
        }
    }

    public void clearNotification() {
        if (this.hasNotification()) {
            this.notification = "";
            this.sendNotification = true;
        }
    }

    public boolean hasNotification() {
        return !"".equals(this.notification);
    }

    private void sendNotification() {
        PacketHandler.INSTANCE.sendToAll((IMessage)new PacketUpdateNotification(this, this.notification));
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (i <= 2) {
            if (ToolType.isTool(stack)) {
                for (int j = 0; j <= 2; ++j) {
                    if (!ToolType.getToolType(stack).itemMatches(this.inventory[j])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (i <= 4) {
            return Fertilizer.isFertilizer(stack);
        }
        if (i <= 8) {
            return (this.inventory[i] != null || !this.isSlotLocked(i)) && FarmersCommune.instance.canPlant(stack);
        }
        return false;
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        if (this.isActive() != this.wasActive) {
            this.wasActive = this.isActive();
            this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    protected boolean checkProgress(boolean redstoneChecksPassed) {
        if (redstoneChecksPassed) {
            this.usePower();
            if (this.canTick(redstoneChecksPassed)) {
                this.doTick();
            }
        }
        return false;
    }

    protected boolean canTick(boolean redstoneChecksPassed) {
        if (!this.shouldDoWorkThisTick(2)) {
            return false;
        }
        if (this.getEnergyStored() < this.getPowerUsePerTick()) {
            this.setNotification("noPower");
            return false;
        }
        return true;
    }

    protected void doTick() {
        Fertilizer fertilizer;
        IHarvestResult harvest;
        if (this.sendNotification && this.shouldDoWorkThisTick(20)) {
            this.sendNotification = false;
            this.sendNotification();
        }
        if (!this.hasPower() && Config.farmActionEnergyUseRF > 0 && Config.farmAxeActionEnergyUseRF > 0) {
            this.setNotification("noPower");
            return;
        }
        if ("noPower".equals(this.notification)) {
            this.clearNotification();
        }
        BlockCoord bc = null;
        int infiniteLoop = 20;
        while (bc == null || bc.equals((Object)this.getLocation()) || !this.field_145850_b.func_72863_F().func_73149_a(bc.x >> 4, bc.z >> 4)) {
            if (infiniteLoop-- <= 0) {
                return;
            }
            bc = this.getNextCoord();
        }
        Block block = this.field_145850_b.func_147439_a(bc.x, bc.y, bc.z);
        if (block == null) {
            return;
        }
        int meta = this.field_145850_b.func_72805_g(bc.x, bc.y, bc.z);
        if (this.farmerJoe == null) {
            this.farmerJoe = new FakeFarmPlayer(MinecraftServer.func_71276_C().func_71218_a(this.field_145850_b.field_73011_w.field_76574_g));
        }
        if (this.isOpen(bc)) {
            FarmersCommune.instance.prepareBlock(this, bc, block, meta);
            block = this.field_145850_b.func_147439_a(bc.x, bc.y, bc.z);
        }
        if (this.isOutputFull()) {
            this.setNotification("outputFull");
            return;
        }
        if (!this.hasPower() && Config.farmActionEnergyUseRF > 0 && Config.farmAxeActionEnergyUseRF > 0) {
            this.setNotification("noPower");
            return;
        }
        if (!this.isOpen(bc) && (harvest = FarmersCommune.instance.harvestBlock(this, bc, block, meta)) != null && harvest.getDrops() != null) {
            PacketFarmAction pkt = new PacketFarmAction(harvest.getHarvestedBlocks());
            PacketHandler.INSTANCE.sendToAllAround((IMessage)pkt, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)bc.x, (double)bc.y, (double)bc.z, 64.0));
            for (EntityItem ei : harvest.getDrops()) {
                if (ei == null) continue;
                this.insertHarvestDrop((Entity)ei, bc);
                if (ei.field_70128_L) continue;
                this.field_145850_b.func_72838_d((Entity)ei);
            }
            return;
        }
        if (!(this.hasPower() || Config.farmBonemealActionEnergyUseRF <= 0 && Config.farmBonemealTryEnergyUseRF <= 0)) {
            this.setNotification("noPower");
            return;
        }
        if (this.hasBonemeal() && this.bonemealCooldown-- <= 0 && ((fertilizer = Fertilizer.getInstance(this.inventory[3])).applyOnPlant() != this.isOpen(bc) || fertilizer.applyOnAir() == this.field_145850_b.func_147437_c(bc.x, bc.y, bc.z))) {
            this.farmerJoe.field_71071_by.field_70462_a[0] = this.inventory[3];
            this.farmerJoe.field_71071_by.field_70461_c = 0;
            if (fertilizer.apply(this.inventory[3], (EntityPlayer)this.farmerJoe, this.field_145850_b, bc)) {
                this.inventory[3] = this.farmerJoe.field_71071_by.field_70462_a[0];
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFarmAction(bc), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)bc.x, (double)bc.y, (double)bc.z, 64.0));
                if (this.inventory[3] != null && this.inventory[3].field_77994_a == 0) {
                    this.inventory[3] = null;
                }
                this.usePower(Config.farmBonemealActionEnergyUseRF);
                this.bonemealCooldown = 20;
            } else {
                this.usePower(Config.farmBonemealTryEnergyUseRF);
                this.bonemealCooldown = 5;
            }
            this.farmerJoe.field_71071_by.field_70462_a[0] = null;
        }
    }

    private boolean hasBonemeal() {
        if (this.inventory[3] != null) {
            return true;
        }
        for (int i = 4; i <= 4; ++i) {
            if (this.inventory[i] == null) continue;
            this.inventory[3] = this.inventory[i];
            this.inventory[i] = null;
            return true;
        }
        return false;
    }

    private boolean isOutputFull() {
        for (int i = this.slotDefinition.minOutputSlot; i <= this.slotDefinition.maxOutputSlot; ++i) {
            ItemStack curStack = this.inventory[i];
            if (curStack != null && curStack.field_77994_a >= curStack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public boolean hasSeed(ItemStack seeds, BlockCoord bc) {
        int slot = this.getSupplySlotForCoord(bc);
        ItemStack inv = this.inventory[slot];
        return inv != null && (inv.field_77994_a > 1 || !this.isSlotLocked(slot)) && inv.func_77969_a(seeds);
    }

    public int isLowOnSaplings(BlockCoord bc) {
        int slot = this.getSupplySlotForCoord(bc);
        ItemStack inv = this.inventory[slot];
        return 90 * (Config.farmSaplingReserveAmount - (inv == null ? 0 : inv.field_77994_a)) / Config.farmSaplingReserveAmount;
    }

    public ItemStack takeSeedFromSupplies(ItemStack stack, BlockCoord forBlock) {
        return this.takeSeedFromSupplies(stack, forBlock, true);
    }

    public ItemStack takeSeedFromSupplies(ItemStack stack, BlockCoord forBlock, boolean matchMetadata) {
        if (stack == null || forBlock == null) {
            return null;
        }
        int slot = this.getSupplySlotForCoord(forBlock);
        ItemStack inv = this.inventory[slot];
        if (inv != null && (matchMetadata ? inv.func_77969_a(stack) : inv.func_77973_b() == stack.func_77973_b())) {
            if (inv.field_77994_a <= 1 && this.isSlotLocked(slot)) {
                return null;
            }
            ItemStack result = inv.func_77946_l();
            result.field_77994_a = 1;
            inv = inv.func_77946_l();
            --inv.field_77994_a;
            if (inv.field_77994_a == 0) {
                inv = null;
            }
            this.func_70299_a(slot, inv);
            return result;
        }
        return null;
    }

    public ItemStack takeSeedFromSupplies(BlockCoord bc) {
        return this.takeSeedFromSupplies(this.getSeedTypeInSuppliesFor(bc), bc);
    }

    public ItemStack getSeedTypeInSuppliesFor(BlockCoord bc) {
        int slot = this.getSupplySlotForCoord(bc);
        ItemStack inv = this.inventory[slot];
        if (!(inv == null || inv.field_77994_a <= 1 && this.isSlotLocked(slot))) {
            return inv.func_77946_l();
        }
        return null;
    }

    protected int getSupplySlotForCoord(BlockCoord forBlock) {
        if (forBlock.x <= this.field_145851_c && forBlock.z > this.field_145849_e) {
            return 5;
        }
        if (forBlock.x > this.field_145851_c && forBlock.z > this.field_145849_e - 1) {
            return 6;
        }
        if (forBlock.x < this.field_145851_c && forBlock.z <= this.field_145849_e) {
            return 7;
        }
        return 8;
    }

    private void insertHarvestDrop(Entity entity, BlockCoord bc) {
        if (!this.field_145850_b.field_72995_K && entity instanceof EntityItem && !entity.field_70128_L) {
            EntityItem item = (EntityItem)entity;
            ItemStack stack = item.func_92059_d().func_77946_l();
            int numInserted = this.insertResult(stack, bc);
            stack.field_77994_a -= numInserted;
            item.func_92058_a(stack);
            if (stack.field_77994_a == 0) {
                item.func_70106_y();
            }
        }
    }

    private int insertResult(ItemStack stack, BlockCoord bc) {
        int slot = bc != null ? this.getSupplySlotForCoord(bc) : 5;
        int[] slots = new int[4];
        int k = 0;
        int j = slot;
        while (j <= 8) {
            slots[k++] = j++;
        }
        j = 5;
        while (j < slot) {
            slots[k++] = j++;
        }
        int origSize = stack.field_77994_a;
        stack = stack.func_77946_l();
        int inserted = 0;
        for (int j2 = 0; j2 < slots.length && inserted < stack.field_77994_a; ++j2) {
            int i = slots[j2];
            ItemStack curStack = this.inventory[i];
            int inventoryStackLimit = this.getInventoryStackLimit(i);
            if (!this.func_94041_b(i, stack) || curStack != null && curStack.field_77994_a >= inventoryStackLimit) continue;
            if (curStack == null) {
                if (stack.field_77994_a < inventoryStackLimit) {
                    this.inventory[i] = stack.func_77946_l();
                    inserted = stack.field_77994_a;
                    continue;
                }
                this.inventory[i] = stack.func_77946_l();
                this.inventory[i].field_77994_a = inserted = inventoryStackLimit;
                continue;
            }
            if (!curStack.func_77969_a(stack)) continue;
            inserted = Math.min(inventoryStackLimit - curStack.field_77994_a, stack.field_77994_a);
            this.inventory[i].field_77994_a += inserted;
        }
        stack.field_77994_a -= inserted;
        if (inserted >= origSize) {
            return origSize;
        }
        IMachineRecipe.ResultStack[] in = new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(stack)};
        this.mergeResults(in);
        return origSize - (in[0].item == null ? 0 : in[0].item.field_77994_a);
    }

    @Nonnull
    private BlockCoord getNextCoord() {
        int size = this.getFarmSize();
        BlockCoord loc = this.getLocation();
        if (this.lastScanned == null) {
            this.lastScanned = new BlockCoord(loc.x - size, loc.y, loc.z - size);
            return this.lastScanned;
        }
        int nextX = this.lastScanned.x + 1;
        int nextZ = this.lastScanned.z;
        if (nextX > loc.x + size) {
            nextX = loc.x - size;
            if (++nextZ > loc.z + size) {
                nextX = loc.x - size;
                nextZ = loc.z - size;
            }
        }
        this.lastScanned = new BlockCoord(nextX, this.lastScanned.y, nextZ);
        return this.lastScanned;
    }

    public void toggleLockedState(int slot) {
        if (this.field_145850_b.field_72995_K) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFarmLockedSlot(this, slot));
        }
        this.lockedSlots.flip(slot);
    }

    public boolean isSlotLocked(int slot) {
        return this.lockedSlots.get(slot);
    }

    @Override
    public String func_145825_b() {
        return EnderIO.blockFarmStation.func_149732_F();
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public String getMachineName() {
        return ModObject.blockFarmStation.unlocalisedName;
    }

    @Override
    public float getProgress() {
        return 0.5f;
    }

    @Override
    public void onCapacitorTypeChange() {
        int ppt = this.calcPowerUsePerTick();
        switch (this.getCapacitorType()) {
            case BASIC_CAPACITOR: {
                this.setCapacitor(new BasicCapacitor(ppt * 40, 250000, ppt));
                break;
            }
            case ACTIVATED_CAPACITOR: {
                this.setCapacitor(new BasicCapacitor(ppt * 40, 500000, ppt));
                break;
            }
            case ENDER_CAPACITOR: {
                this.setCapacitor(new BasicCapacitor(ppt * 40, 1000000, ppt));
            }
        }
        this.currentTask = this.createTask();
    }

    private int calcPowerUsePerTick() {
        return Math.round((float)Config.farmContinuousEnergyUseRF * ((float)this.getFarmSize() / (float)Config.farmDefaultSize));
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtRoot) {
        super.readCustomNBT(nbtRoot);
        this.currentTask = this.createTask();
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        super.readCommon(nbtRoot);
        this.lockedSlots.clear();
        for (int i : nbtRoot.func_74759_k("lockedSlots")) {
            this.lockedSlots.set(i);
        }
        int slotLayoutVersion = nbtRoot.func_74762_e("slotLayoutVersion");
        if (slotLayoutVersion == 0) {
            this.inventory = new ArrayMappingTool<ItemStack>("TTSSSSOOOOC", "TTTBBSSSSOOOOOOC").map(this.inventory);
        } else if (slotLayoutVersion == 1) {
            this.inventory = new ArrayMappingTool<ItemStack>("TTTSSSSOOOOC", "TTTBBSSSSOOOOOOC").map(this.inventory);
        } else if (slotLayoutVersion == 2) {
            this.inventory = new ArrayMappingTool<ItemStack>("TTTSSSSOOOOOOC", "TTTBBSSSSOOOOOOC").map(this.inventory);
        }
    }

    IPoweredTask createTask() {
        return new ContinuousTask(this.getPowerUsePerTick());
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        super.writeCustomNBT(nbtRoot);
        nbtRoot.func_74757_a("isActive", this.isActive());
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        super.writeCommon(nbtRoot);
        if (!this.lockedSlots.isEmpty()) {
            int[] locked = new int[this.lockedSlots.cardinality()];
            int i = 0;
            int bit = -1;
            while ((bit = this.lockedSlots.nextSetBit(bit + 1)) >= 0) {
                locked[i] = bit;
                ++i;
            }
            nbtRoot.func_74783_a("lockedSlots", locked);
        }
        nbtRoot.func_74768_a("slotLayoutVersion", 3);
    }

    @Override
    public int getInventoryStackLimit(int slot) {
        if (slot >= 5 && slot <= 8) {
            switch (this.getCapacitorType()) {
                case BASIC_CAPACITOR: {
                    return 16;
                }
                case ACTIVATED_CAPACITOR: {
                    return 32;
                }
                case ENDER_CAPACITOR: {
                    return 64;
                }
            }
        }
        return 64;
    }

    @Override
    public int func_70297_j_() {
        return this.getInventoryStackLimit(5);
    }

    public static enum ToolType {
        HOE{

            @Override
            boolean match(ItemStack item) {
                for (ItemStack stack : Config.farmHoes) {
                    if (stack.func_77973_b() != item.func_77973_b()) continue;
                    return true;
                }
                return false;
            }
        }
        ,
        AXE{

            @Override
            boolean match(ItemStack item) {
                return item.func_77973_b().getHarvestLevel(item, "axe") >= 0;
            }
        }
        ,
        TREETAP{

            @Override
            boolean match(ItemStack item) {
                return item.func_77973_b().getClass() == RubberTreeFarmerIC2.treeTap;
            }
        }
        ,
        SHEARS{

            @Override
            boolean match(ItemStack item) {
                return item.func_77973_b() instanceof ItemShears;
            }
        }
        ,
        NONE{

            @Override
            boolean match(ItemStack item) {
                return false;
            }
        };


        public final boolean itemMatches(ItemStack item) {
            if (item == null) {
                return false;
            }
            return this.match(item) && !this.isBrokenTinkerTool(item);
        }

        private boolean isBrokenTinkerTool(ItemStack item) {
            return item.func_77942_o() && item.func_77978_p().func_74764_b("InfiTool") && item.func_77978_p().func_74775_l("InfiTool").func_74767_n("Broken");
        }

        abstract boolean match(ItemStack var1);

        public static boolean isTool(ItemStack stack) {
            for (ToolType type : ToolType.values()) {
                if (!type.itemMatches(stack)) continue;
                return true;
            }
            return false;
        }

        public static ToolType getToolType(ItemStack stack) {
            for (ToolType type : ToolType.values()) {
                if (!type.itemMatches(stack)) continue;
                return type;
            }
            return NONE;
        }
    }
}

