/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import java.util.List;
import mcjty.lib.varia.Coordinate;
import mcjty.rftools.blocks.shield.ShieldTEBase;
import mcjty.rftools.blocks.shield.filters.PlayerFilter;
import mcjty.rftools.blocks.shield.filters.ShieldFilter;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class ShieldBlockTileEntity
extends TileEntity {
    private Block block;
    private int camoId = -1;
    private int hasTe = 0;
    private int shieldColor;
    private int damageBits = 0;
    private int collisionData = 0;
    private int damageTimer = 10;
    private AxisAlignedBB beamBox = null;
    private Coordinate shieldBlock;

    public void setDamageBits(int damageBits) {
        this.damageBits = damageBits;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getCollisionData() {
        return this.collisionData;
    }

    public void setCollisionData(int collisionData) {
        this.collisionData = collisionData;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getShieldColor() {
        return this.shieldColor;
    }

    public void setShieldColor(int shieldColor) {
        this.shieldColor = shieldColor;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setCamoBlock(int camoId, int hasTe) {
        this.camoId = camoId;
        this.hasTe = hasTe;
        this.block = camoId == -1 ? null : Block.func_149729_e((int)camoId);
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.damageBits != 0) {
            this.handleDamage();
        }
    }

    private void handleDamage() {
        ShieldTEBase shieldTileEntity;
        --this.damageTimer;
        if (this.damageTimer > 0) {
            return;
        }
        this.damageTimer = 10;
        if (this.beamBox == null) {
            this.beamBox = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 0.4), (double)((double)this.field_145848_d - 0.4), (double)((double)this.field_145849_e - 0.4), (double)((double)this.field_145851_c + 1.4), (double)((double)this.field_145848_d + 2.0), (double)((double)this.field_145849_e + 1.4));
        }
        if (this.shieldBlock != null && (shieldTileEntity = (ShieldTEBase)this.field_145850_b.func_147438_o(this.shieldBlock.getX(), this.shieldBlock.getY(), this.shieldBlock.getZ())) != null) {
            List l = this.field_145850_b.func_72872_a(Entity.class, this.beamBox);
            for (Entity entity : l) {
                if ((this.damageBits & 4) != 0 && entity instanceof IMob) {
                    if (!this.checkEntityDamage(shieldTileEntity, "hostile")) continue;
                    shieldTileEntity.applyDamageToEntity(entity);
                    continue;
                }
                if ((this.damageBits & 2) != 0 && entity instanceof IAnimals) {
                    if (!this.checkEntityDamage(shieldTileEntity, "animal")) continue;
                    shieldTileEntity.applyDamageToEntity(entity);
                    continue;
                }
                if ((this.damageBits & 8) == 0 || !(entity instanceof EntityPlayer) || !this.checkPlayerDamage(shieldTileEntity, (EntityPlayer)entity)) continue;
                shieldTileEntity.applyDamageToEntity(entity);
            }
        }
    }

    private boolean checkEntityDamage(ShieldTEBase shieldTileEntity, String filterName) {
        List<ShieldFilter> filters = shieldTileEntity.getFilters();
        for (ShieldFilter filter : filters) {
            if ("default".equals(filter.getFilterName())) {
                return (filter.getAction() & 2) != 0;
            }
            if (!filterName.equals(filter.getFilterName())) continue;
            return (filter.getAction() & 2) != 0;
        }
        return false;
    }

    private boolean checkPlayerDamage(ShieldTEBase shieldTileEntity, EntityPlayer entity) {
        List<ShieldFilter> filters = shieldTileEntity.getFilters();
        for (ShieldFilter filter : filters) {
            if ("default".equals(filter.getFilterName())) {
                return (filter.getAction() & 2) != 0;
            }
            if (!"player".equals(filter.getFilterName())) continue;
            PlayerFilter playerFilter = (PlayerFilter)filter;
            String name = playerFilter.getName();
            if (name == null || name.isEmpty()) {
                return (filter.getAction() & 2) != 0;
            }
            if (!name.equals(entity.getDisplayName())) continue;
            return (filter.getAction() & 2) != 0;
        }
        return false;
    }

    public void setShieldBlock(Coordinate c) {
        this.shieldBlock = c;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Coordinate getShieldBlock() {
        return this.shieldBlock;
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean getHasTe() {
        return this.hasTe != 0;
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("camoId", this.camoId);
        tagCompound.func_74768_a("hasTe", this.hasTe);
        tagCompound.func_74768_a("damageBits", this.damageBits);
        tagCompound.func_74768_a("collisionData", this.collisionData);
        tagCompound.func_74768_a("shieldColor", this.shieldColor);
        if (this.shieldBlock != null) {
            tagCompound.func_74768_a("shieldX", this.shieldBlock.getX());
            tagCompound.func_74768_a("shieldY", this.shieldBlock.getY());
            tagCompound.func_74768_a("shieldZ", this.shieldBlock.getZ());
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.camoId = tagCompound.func_74762_e("camoId");
        this.hasTe = tagCompound.func_74762_e("hasTe");
        this.block = this.camoId == -1 ? null : Block.func_149729_e((int)this.camoId);
        this.damageBits = tagCompound.func_74762_e("damageBits");
        this.collisionData = tagCompound.func_74762_e("collisionData");
        this.shieldColor = tagCompound.func_74762_e("shieldColor");
        if (this.shieldColor == 0) {
            this.shieldColor = 9895880;
        }
        int sx = tagCompound.func_74762_e("shieldX");
        int sy = tagCompound.func_74762_e("shieldY");
        int sz = tagCompound.func_74762_e("shieldZ");
        this.shieldBlock = new Coordinate(sx, sy, sz);
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }
}

