/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import mcjty.rftools.blocks.storage.RemoteStorageIdRegistry;
import mcjty.rftools.blocks.storage.RemoteStorageTileEntity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class RemoteStorageItemInventory
implements IInventory {
    private ItemStack[] stacks = new ItemStack[300];
    private final EntityPlayer entityPlayer;

    public RemoteStorageItemInventory(EntityPlayer player) {
        this.entityPlayer = player;
    }

    private RemoteStorageTileEntity getRemoteStorage() {
        int id = this.getStorageID();
        if (id == -1) {
            return null;
        }
        return RemoteStorageIdRegistry.getRemoteStorage(this.entityPlayer.field_70170_p, id);
    }

    private int getStorageID() {
        if (this.entityPlayer.func_70694_bm() == null || this.entityPlayer.func_70694_bm().func_77978_p() == null) {
            return -1;
        }
        return this.entityPlayer.func_70694_bm().func_77978_p().func_74762_e("id");
    }

    private boolean isServer() {
        return !this.entityPlayer.field_70170_p.field_72995_K;
    }

    private ItemStack[] getStacks() {
        if (this.isServer()) {
            RemoteStorageTileEntity storage = this.getRemoteStorage();
            if (storage == null) {
                return new ItemStack[0];
            }
            int si = storage.findRemoteIndex(this.getStorageID());
            if (si == -1) {
                return new ItemStack[0];
            }
            return storage.getRemoteStacks(si);
        }
        int maxSize = this.entityPlayer.func_70694_bm().func_77978_p().func_74762_e("maxSize");
        if (maxSize != this.stacks.length) {
            this.stacks = new ItemStack[maxSize];
        }
        return this.stacks;
    }

    public int func_70302_i_() {
        if (this.isServer()) {
            RemoteStorageTileEntity storage = this.getRemoteStorage();
            if (storage == null) {
                return 0;
            }
            int si = storage.findRemoteIndex(this.getStorageID());
            if (si == -1) {
                return 0;
            }
            int maxStacks = storage.getMaxStacks(si);
            this.entityPlayer.func_70694_bm().func_77978_p().func_74768_a("maxSize", maxStacks);
            return maxStacks;
        }
        return this.entityPlayer.func_70694_bm().func_77978_p().func_74762_e("maxSize");
    }

    public ItemStack func_70301_a(int index) {
        if (this.isServer()) {
            RemoteStorageTileEntity storage = this.getRemoteStorage();
            if (storage == null) {
                return null;
            }
            int si = storage.findRemoteIndex(this.getStorageID());
            if (si == -1) {
                return null;
            }
            return storage.getRemoteSlot(si, index);
        }
        return this.stacks[index];
    }

    public ItemStack func_70298_a(int index, int amount) {
        if (this.isServer()) {
            RemoteStorageTileEntity storage = this.getRemoteStorage();
            if (storage == null) {
                return null;
            }
            int si = storage.findRemoteIndex(this.getStorageID());
            if (si == -1) {
                return null;
            }
            return storage.decrStackSizeRemote(si, index, amount);
        }
        if (index >= this.stacks.length) {
            return null;
        }
        if (this.stacks[index] != null) {
            this.func_70296_d();
            if (this.stacks[index].field_77994_a <= amount) {
                ItemStack old = this.stacks[index];
                this.stacks[index] = null;
                return old;
            }
            ItemStack its = this.stacks[index].func_77979_a(amount);
            if (this.stacks[index].field_77994_a == 0) {
                this.stacks[index] = null;
            }
            return its;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (this.isServer()) {
            RemoteStorageTileEntity storage = this.getRemoteStorage();
            if (storage == null) {
                return;
            }
            int si = storage.findRemoteIndex(this.getStorageID());
            if (si == -1) {
                return;
            }
            storage.updateRemoteSlot(si, this.func_70297_j_(), index, stack);
        } else {
            if (index >= this.stacks.length) {
                return;
            }
            this.stacks[index] = stack;
            if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
                stack.field_77994_a = this.func_70297_j_();
            }
            this.func_70296_d();
        }
    }

    public String func_145825_b() {
        return "remote storage";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        RemoteStorageTileEntity storage = this.getRemoteStorage();
        if (storage != null) {
            storage.func_70296_d();
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        ItemStack[] s = this.getStacks();
        if (index >= s.length) {
            return false;
        }
        if (this.isServer()) {
            RemoteStorageTileEntity storage = this.getRemoteStorage();
            if (storage == null) {
                return false;
            }
            int si = storage.findRemoteIndex(this.getStorageID());
            if (si == -1) {
                return false;
            }
            if (index >= storage.getMaxStacks(si)) {
                return false;
            }
        }
        return true;
    }
}

