/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage.sorters;

import java.util.Comparator;
import mcjty.rftools.blocks.dimlets.DimletSetup;
import mcjty.rftools.blocks.storage.sorters.DimletTypeItemSorter;
import mcjty.rftools.blocks.storage.sorters.ItemSorter;
import mcjty.rftools.items.dimlets.DimletEntry;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.KnownDimletConfiguration;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class DimletRarityItemSorter
implements ItemSorter {
    @Override
    public String getName() {
        return "rarity";
    }

    @Override
    public String getTooltip() {
        return "Sort on dimlet rarity";
    }

    @Override
    public int getU() {
        return 240;
    }

    @Override
    public int getV() {
        return 16;
    }

    @Override
    public Comparator<Pair<ItemStack, Integer>> getComparator() {
        return new Comparator<Pair<ItemStack, Integer>>(){

            @Override
            public int compare(Pair<ItemStack, Integer> o1, Pair<ItemStack, Integer> o2) {
                int rarity2;
                int rarity1 = DimletRarityItemSorter.this.getRarity((Pair<ItemStack, Integer>)o1);
                if (rarity1 == (rarity2 = DimletRarityItemSorter.this.getRarity((Pair<ItemStack, Integer>)o2))) {
                    return DimletTypeItemSorter.compareTypes(o1, o2);
                }
                return new Integer(rarity1).compareTo(rarity2);
            }
        };
    }

    private int getRarity(Pair<ItemStack, Integer> object) {
        DimletKey key;
        DimletEntry entry;
        int rarity = -1;
        if (((ItemStack)object.getKey()).func_77973_b() == DimletSetup.knownDimlet && (entry = KnownDimletConfiguration.getEntry(key = KnownDimletConfiguration.getDimletKey((ItemStack)object.getKey(), null))) != null) {
            rarity = entry.getRarity();
        }
        return rarity;
    }

    @Override
    public boolean isSameGroup(Pair<ItemStack, Integer> o1, Pair<ItemStack, Integer> o2) {
        int rarity2;
        int rarity1 = this.getRarity(o1);
        return rarity1 == (rarity2 = this.getRarity(o2));
    }

    @Override
    public String getGroupName(Pair<ItemStack, Integer> object) {
        int rarity = this.getRarity(object);
        return "Rarity " + (rarity == -1 ? "unknown" : Integer.valueOf(rarity));
    }
}

