/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.dimension.network.PacketReturnDestinationInfo;
import net.minecraft.world.World;

public class PacketGetDestinationInfo
implements IMessage,
IMessageHandler<PacketGetDestinationInfo, PacketReturnDestinationInfo> {
    private int receiverId;

    public void fromBytes(ByteBuf buf) {
        this.receiverId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.receiverId);
    }

    public PacketGetDestinationInfo() {
    }

    public PacketGetDestinationInfo(int receiverId) {
        this.receiverId = receiverId;
    }

    public PacketReturnDestinationInfo onMessage(PacketGetDestinationInfo message, MessageContext ctx) {
        String name;
        World world = ctx.getServerHandler().field_147369_b.field_70170_p;
        TeleportDestinations destinations = TeleportDestinations.getDestinations(world);
        GlobalCoordinate coordinate = destinations.getCoordinateForId(message.receiverId);
        if (coordinate == null) {
            name = "?";
        } else {
            TeleportDestination destination = destinations.getDestination(coordinate);
            if (destination == null) {
                name = "?";
            } else {
                name = destination.getName();
                if (name == null || name.isEmpty()) {
                    name = destination.getCoordinate() + " (" + destination.getDimension() + ")";
                }
            }
        }
        return new PacketReturnDestinationInfo(message.receiverId, name);
    }
}

