/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension.world.terrain;

import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.dimension.world.terrain.NormalTerrainGenerator;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class WavesTerrainGenerator
extends NormalTerrainGenerator {
    private final boolean filled;

    public WavesTerrainGenerator(boolean filled) {
        this.filled = filled;
    }

    @Override
    public void generate(int chunkX, int chunkZ, Block[] aBlock, byte[] abyte) {
        Block baseBlock = this.provider.dimensionInformation.getBaseBlockForTerrain().getBlock();
        byte baseMeta = this.provider.dimensionInformation.getBaseBlockForTerrain().getMeta();
        Block baseFluid = this.provider.dimensionInformation.getFluidForTerrain();
        int index = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int height;
                double sin = Math.sin((float)(chunkX * 16 + x) / 16.0f);
                double cos = Math.cos((float)(chunkZ * 16 + z) / 16.0f);
                byte waterLevel = (byte)(63.0 + sin * cos * 16.0);
                for (height = 0; height < DimletConfiguration.bedrockLayer; ++height) {
                    aBlock[index] = Blocks.field_150357_h;
                    abyte[index++] = 0;
                }
                if (baseMeta == 127) {
                    while (height < waterLevel) {
                        aBlock[index] = baseBlock;
                        abyte[index++] = (byte)(height / 2 + x / 2 + z / 2 & 0xF);
                        ++height;
                    }
                } else {
                    while (height < waterLevel) {
                        aBlock[index] = baseBlock;
                        abyte[index++] = baseMeta;
                        ++height;
                    }
                }
                if (this.filled) {
                    while (height < 63) {
                        aBlock[index] = baseFluid;
                        abyte[index++] = baseMeta;
                        ++height;
                    }
                }
                while (height < 256) {
                    aBlock[index++] = null;
                    ++height;
                }
            }
        }
    }
}

