/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.smartwrench;

import cofh.api.item.IToolHammer;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mcjty.lib.varia.Coordinate;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.rftools.items.smartwrench.SmartWrench;
import mcjty.rftools.items.smartwrench.SmartWrenchMode;
import mcjty.rftools.items.smartwrench.SmartWrenchSelector;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.item.IToolHammer", modid="CoFHLib")})
public class SmartWrenchItem
extends Item
implements IToolHammer,
SmartWrench {
    private IIcon wrenchIcon;
    private IIcon selectIcon;

    public SmartWrenchItem() {
        this.func_77625_d(1);
    }

    @Optional.Method(modid="CoFHLib")
    public boolean isUsable(ItemStack item, EntityLivingBase user, int x, int y, int z) {
        SmartWrenchMode mode = SmartWrenchItem.getCurrentMode(item);
        return mode == SmartWrenchMode.MODE_WRENCH;
    }

    @Optional.Method(modid="CoFHLib")
    public void toolUsed(ItemStack item, EntityLivingBase user, int x, int y, int z) {
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            SmartWrenchMode mode = SmartWrenchItem.getCurrentMode(stack);
            mode = mode == SmartWrenchMode.MODE_WRENCH ? SmartWrenchMode.MODE_SELECT : SmartWrenchMode.MODE_WRENCH;
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound == null) {
                tagCompound = new NBTTagCompound();
                stack.func_77982_d(tagCompound);
            }
            tagCompound.func_74778_a("mode", mode.getCode());
            Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.YELLOW + "Smart wrench is now in " + mode.getName() + " mode."));
        }
        return super.func_77659_a(stack, world, player);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float sx, float sy, float sz) {
        GlobalCoordinate b;
        SmartWrenchMode mode;
        if (!world.field_72995_K && (mode = SmartWrenchItem.getCurrentMode(stack)) == SmartWrenchMode.MODE_SELECT && (b = SmartWrenchItem.getCurrentBlock(stack)) != null) {
            if (b.getDimension() != world.field_73011_w.field_76574_g) {
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "The selected block is in another dimension!"));
                return true;
            }
            TileEntity te = world.func_147438_o(b.getCoordinate().getX(), b.getCoordinate().getY(), b.getCoordinate().getZ());
            if (te instanceof SmartWrenchSelector) {
                SmartWrenchSelector smartWrenchSelector = (SmartWrenchSelector)te;
                smartWrenchSelector.selectBlock(player, x, y, z);
            }
        }
        return true;
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        GlobalCoordinate b = SmartWrenchItem.getCurrentBlock(itemStack);
        if (b != null) {
            list.add(EnumChatFormatting.GREEN + "Block: " + b.getCoordinate().toString() + " at dimension " + b.getDimension());
        }
        SmartWrenchMode mode = SmartWrenchItem.getCurrentMode(itemStack);
        list.add(EnumChatFormatting.WHITE + "Right-click on air to change mode.");
        list.add(EnumChatFormatting.GREEN + "Mode: " + mode.getName());
        if (mode == SmartWrenchMode.MODE_WRENCH) {
            list.add(EnumChatFormatting.WHITE + "Use as a normal wrench:");
            list.add(EnumChatFormatting.WHITE + "    Sneak-right-click to pick up machines.");
            list.add(EnumChatFormatting.WHITE + "    Right-click to rotate machines.");
        } else if (mode == SmartWrenchMode.MODE_SELECT) {
            list.add(EnumChatFormatting.WHITE + "Use as a block selector:");
            list.add(EnumChatFormatting.WHITE + "    Sneak-right-click select master block.");
            list.add(EnumChatFormatting.WHITE + "    Right-click to associate blocks with master.");
        }
    }

    @Override
    public SmartWrenchMode getMode(ItemStack itemStack) {
        String modeString;
        SmartWrenchMode mode = SmartWrenchMode.MODE_WRENCH;
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && (modeString = tagCompound.func_74779_i("mode")) != null && !modeString.isEmpty()) {
            mode = SmartWrenchMode.getMode(modeString);
        }
        return mode;
    }

    public static SmartWrenchMode getCurrentMode(ItemStack itemStack) {
        String modeString;
        SmartWrenchMode mode = SmartWrenchMode.MODE_WRENCH;
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && (modeString = tagCompound.func_74779_i("mode")) != null && !modeString.isEmpty()) {
            mode = SmartWrenchMode.getMode(modeString);
        }
        return mode;
    }

    public static void setCurrentBlock(ItemStack itemStack, GlobalCoordinate c) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            itemStack.func_77982_d(tagCompound);
        }
        if (c == null) {
            tagCompound.func_82580_o("selectedX");
            tagCompound.func_82580_o("selectedY");
            tagCompound.func_82580_o("selectedZ");
            tagCompound.func_82580_o("selectedDim");
        } else {
            tagCompound.func_74768_a("selectedX", c.getCoordinate().getX());
            tagCompound.func_74768_a("selectedY", c.getCoordinate().getY());
            tagCompound.func_74768_a("selectedZ", c.getCoordinate().getZ());
            tagCompound.func_74768_a("selectedDim", c.getDimension());
        }
    }

    public static GlobalCoordinate getCurrentBlock(ItemStack itemStack) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("selectedX")) {
            int x = tagCompound.func_74762_e("selectedX");
            int y = tagCompound.func_74762_e("selectedY");
            int z = tagCompound.func_74762_e("selectedZ");
            int dim = tagCompound.func_74762_e("selectedDim");
            return new GlobalCoordinate(new Coordinate(x, y, z), dim);
        }
        return null;
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        super.func_94581_a(iconRegister);
        this.wrenchIcon = iconRegister.func_94245_a("rftools:smartWrenchItem");
        this.selectIcon = iconRegister.func_94245_a("rftools:smartWrenchSelectItem");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        SmartWrenchMode mode = SmartWrenchItem.getCurrentMode(stack);
        if (mode == SmartWrenchMode.MODE_SELECT) {
            return this.selectIcon;
        }
        return this.wrenchIcon;
    }
}

