/*
 * Decompiled with CFR 0.152.
 */
package unwrittenfun.minecraft.immersiveintegration.tiles;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import unwrittenfun.minecraft.immersiveintegration.utils.MathUtils;
import unwrittenfun.minecraft.immersiveintegration.utils.SidedItemStack;
import unwrittenfun.minecraft.immersiveintegration.utils.TileUtils;

public class TileItemRobin
extends TileEntity
implements ISidedInventory,
IEBlockInterfaces.IBlockOverlayText {
    public int currentSide = 0;
    public ArrayList<SidedItemStack> itemBuffer = new ArrayList();
    protected int[] sideCount = new int[6];
    protected boolean locked;
    private int cachedSideCount = 0;

    public void func_145845_h() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && this.itemBuffer.size() > 0) {
            SidedItemStack sidedStack = this.itemBuffer.get(0);
            if (this.currentSide != sidedStack.getSide().ordinal() && this.cachedSideCount > 0) {
                ForgeDirection currentDir = ForgeDirection.getOrientation((int)this.currentSide);
                TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + currentDir.offsetX, this.field_145848_d + currentDir.offsetY, this.field_145849_e + currentDir.offsetZ);
                ItemStack smallStack = sidedStack.getStack().func_77946_l();
                smallStack.field_77994_a = Math.min(sidedStack.getStack().field_77994_a, this.cachedSideCount);
                if (tileEntity instanceof IInventory && Utils.canInsertStackIntoInventory((IInventory)((IInventory)tileEntity), (ItemStack)smallStack, (int)ForgeDirection.OPPOSITES[this.currentSide])) {
                    int prevSize = smallStack.field_77994_a;
                    if ((smallStack = Utils.insertStackIntoInventory((IInventory)((IInventory)tileEntity), (ItemStack)smallStack, (int)ForgeDirection.OPPOSITES[this.currentSide])) == null) {
                        this.cachedSideCount -= prevSize;
                        sidedStack.getStack().field_77994_a -= prevSize;
                    } else {
                        this.cachedSideCount -= prevSize - smallStack.field_77994_a;
                        sidedStack.getStack().field_77994_a -= prevSize - smallStack.field_77994_a;
                    }
                    if (sidedStack.getStack().field_77994_a == 0) {
                        this.itemBuffer.remove(sidedStack);
                    }
                } else {
                    this.cachedSideCount = 0;
                }
            }
            if (this.cachedSideCount == 0) {
                this.currentSide = MathUtils.increment(this.currentSide, 5);
                this.cachedSideCount = this.sideCount[this.currentSide];
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            for (SidedItemStack sidedStack : this.itemBuffer) {
                TileUtils.dropItemStack(sidedStack.getStack(), this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            }
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74783_a("sideCount", this.sideCount);
        compound.func_74768_a("currentSide", this.currentSide);
        compound.func_74768_a("cachedSideCount", this.cachedSideCount);
        compound.func_74757_a("locked", this.locked);
        NBTTagList itemList = new NBTTagList();
        for (SidedItemStack sidedStack : this.itemBuffer) {
            NBTTagCompound stackCompound = new NBTTagCompound();
            sidedStack.writeToNBT(stackCompound);
            itemList.func_74742_a((NBTBase)stackCompound);
        }
        compound.func_74782_a("items", (NBTBase)itemList);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.sideCount = compound.func_74759_k("sideCount");
        this.currentSide = compound.func_74762_e("currentSide");
        this.cachedSideCount = compound.func_74762_e("cachedSideCount");
        this.locked = compound.func_74767_n("locked");
        NBTTagList itemList = compound.func_150295_c("items", 10);
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound stackCompound = itemList.func_150305_b(i);
            this.itemBuffer.add(SidedItemStack.loadFromNBT(stackCompound));
        }
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.sideCount = pkt.func_148857_g().func_74759_k("sideCount");
        this.locked = pkt.func_148857_g().func_74767_n("locked");
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74783_a("sideCount", this.sideCount);
        compound.func_74757_a("locked", this.locked);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 3, compound);
    }

    public void setSideCount(int side, int count) {
        this.sideCount[side] = count;
        if (this.currentSide == side) {
            this.cachedSideCount = count;
        }
    }

    public int[] func_94128_d(int side) {
        return new int[]{side};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return side == slot;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int stack) {
        return null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return null;
    }

    public ItemStack func_70304_b(int stack) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.itemBuffer.add(new SidedItemStack(stack, slot));
    }

    public String func_145825_b() {
        return "Item Robin";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public String[] getOverlayText(EntityPlayer player, MovingObjectPosition mop, boolean hammer) {
        if (!hammer) {
            return null;
        }
        return new String[]{StatCollector.func_74838_a((String)("desc.ImmersiveEngineering.info.blockSide." + ForgeDirection.getOrientation((int)mop.field_72310_e))), StatCollector.func_74837_a((String)"immersiveintegration.chat.itemRobin.itemCount", (Object[])new Object[]{this.sideCount[mop.field_72310_e]}), this.locked ? StatCollector.func_74838_a((String)"immersiveintegration.chat.itemRobin.locked") : ""};
    }

    public void toggleLocked() {
        this.locked = !this.locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean useNixieFont(EntityPlayer player, MovingObjectPosition mop) {
        return false;
    }
}

