/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocator;

import codechicken.core.fluid.FluidUtils;
import codechicken.core.fluid.TankAccess;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import codechicken.translocator.TileTranslocator;
import codechicken.translocator.TranslocatorSPH;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileLiquidTranslocator
extends TileTranslocator
implements IFluidHandler {
    public LinkedList<MovingLiquid> movingLiquids = new LinkedList();
    public LinkedList<MovingLiquid> exitingLiquids = new LinkedList();

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            Iterator iterator = this.movingLiquids.iterator();
            while (iterator.hasNext()) {
                MovingLiquid m = (MovingLiquid)iterator.next();
                if (!m.update()) continue;
                iterator.remove();
                this.exitingLiquids.add(m);
            }
            iterator = this.exitingLiquids.iterator();
            while (iterator.hasNext()) {
                if (!((MovingLiquid)iterator.next()).update()) continue;
                iterator.remove();
            }
        } else {
            BlockCoord pos = new BlockCoord((TileEntity)this);
            TankAccess[] attached = new TankAccess[6];
            int[] outputs = null;
            int[] r_outputs = null;
            for (int i = 0; i < 6; ++i) {
                TileTranslocator.Attachment a = this.attachments[i];
                if (a == null) continue;
                BlockCoord invpos = pos.copy().offset(i);
                TileEntity tile = this.field_145850_b.func_147438_o(invpos.x, invpos.y, invpos.z);
                if (!(tile instanceof IFluidHandler)) {
                    this.harvestPart(i, true);
                    continue;
                }
                attached[i] = new TankAccess((IFluidHandler)tile, i ^ 1);
            }
            ArrayList<LiquidTransfer> transfers = new ArrayList<LiquidTransfer>();
            for (int i = 0; i < 6; ++i) {
                TileTranslocator.Attachment a = this.attachments[i];
                if (a == null || !a.a_eject) continue;
                TankAccess t = attached[i];
                FluidStack drain = t.drain(a.fast ? 1000 : 100, false);
                if (drain == null || drain.amount == 0) continue;
                if (outputs == null) {
                    outputs = this.sortOutputs(false);
                    r_outputs = this.sortOutputs(true);
                }
                FluidStack move = drain.copy();
                this.spreadOutput(move, i, outputs, attached, transfers);
                this.spreadOutput(move, i, r_outputs, attached, transfers);
                t.drain(drain.amount - move.amount, true);
            }
            if (!transfers.isEmpty()) {
                this.sendTransferPacket(transfers);
            }
        }
    }

    private void spreadOutput(FluidStack move, int src, int[] outputs, TankAccess[] attached, ArrayList<LiquidTransfer> transfers) {
        for (int k = 0; k < outputs.length && move.amount > 0; ++k) {
            int dst = outputs[k];
            TankAccess outaccess = attached[dst];
            int fit = outaccess.fill(move, false);
            int spread = outputs.length - k;
            if ((fit = Math.min(fit, move.amount / spread + this.field_145850_b.field_73012_v.nextInt(move.amount % spread + 1))) == 0) continue;
            FluidStack add = FluidUtils.copy((FluidStack)move, (int)fit);
            outaccess.fill(add, true);
            move.amount -= fit;
            transfers.add(new LiquidTransfer(src, dst, add));
        }
    }

    public int[] sortOutputs(boolean b) {
        int[] str = new int[6];
        int k = 0;
        for (int i = 0; i < 6; ++i) {
            TileTranslocator.Attachment a = this.attachments[i];
            if (a == null || a.a_eject || a.redstone != b) continue;
            str[k++] = i;
        }
        int[] ret = new int[k];
        System.arraycopy(str, 0, ret, 0, k);
        return ret;
    }

    private void sendTransferPacket(ArrayList<LiquidTransfer> transfers) {
        PacketCustom packet = new PacketCustom(TranslocatorSPH.channel, 2);
        packet.writeCoord(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        packet.writeByte(transfers.size());
        for (LiquidTransfer t : transfers) {
            packet.writeByte(t.key);
            packet.writeFluidStack(t.liquid);
        }
        packet.sendToChunk(this.field_145850_b, this.field_145851_c >> 4, this.field_145849_e >> 4);
    }

    @Override
    public void handleDescriptionPacket(PacketCustom packet) {
        if (packet.getType() == 2) {
            ArrayList<LiquidTransfer> transfers = new ArrayList<LiquidTransfer>();
            HashSet<Integer> maintainingKeys = new HashSet<Integer>();
            int k = packet.readUByte();
            for (int i = 0; i < k; ++i) {
                LiquidTransfer t = new LiquidTransfer(packet.readUByte(), packet.readFluidStack());
                transfers.add(t);
                maintainingKeys.add(t.key);
            }
            for (LiquidTransfer t : transfers) {
                int src = t.key >> 4;
                int dst = t.key & 0xF;
                boolean found = false;
                Iterator iterator = this.movingLiquids.iterator();
                while (iterator.hasNext()) {
                    MovingLiquid m = (MovingLiquid)iterator.next();
                    if (m.liquid.isFluidEqual(t.liquid) && m.src == src && m.dst == dst) {
                        m.addLiquid(t.liquid.amount);
                        found = true;
                        continue;
                    }
                    if (m.dst != dst && m.src != src || maintainingKeys.contains(m.src << 4 | m.dst)) continue;
                    iterator.remove();
                    m.finish();
                    this.exitingLiquids.add(m);
                }
                if (found || this.attachments[src] == null) continue;
                this.movingLiquids.add(new MovingLiquid(src, dst, t.liquid));
            }
        } else {
            super.handleDescriptionPacket(packet);
        }
    }

    public Iterable<MovingLiquid> movingLiquids() {
        ArrayList<MovingLiquid> comp = new ArrayList<MovingLiquid>();
        comp.addAll(this.movingLiquids);
        comp.addAll(this.exitingLiquids);
        return comp;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (from == ForgeDirection.UNKNOWN) {
            LinkedList<FluidTankInfo> list = new LinkedList<FluidTankInfo>();
            for (TileTranslocator.Attachment a : this.attachments) {
                if (a == null) continue;
                list.add(new FluidTankInfo(null, 0));
            }
            return list.toArray(new FluidTankInfo[0]);
        }
        if (this.attachments[from.ordinal()] != null) {
            return new FluidTankInfo[]{new FluidTankInfo(null, 0)};
        }
        return new FluidTankInfo[0];
    }

    private class LiquidTransfer {
        int key;
        FluidStack liquid;

        public LiquidTransfer(int src, int dst, FluidStack liquid) {
            this.key = src << 4 | dst;
            this.liquid = liquid;
        }

        public LiquidTransfer(int key, FluidStack liquid) {
            this.key = key;
            this.liquid = liquid;
        }
    }

    public class MovingLiquid {
        public int src;
        public int dst;
        public FluidStack liquid;
        public double a_start;
        public double b_start;
        public double a_end;
        public double b_end;
        public boolean fast;

        public MovingLiquid(int src, int dst, FluidStack add) {
            this.src = src;
            this.dst = dst;
            this.liquid = add;
            this.fast = TileLiquidTranslocator.this.attachments[src].fast;
            this.capLiquid();
        }

        private void capLiquid() {
            this.liquid.amount = Math.min(this.liquid.amount, this.fast ? 1000 : 100);
        }

        public boolean update() {
            if (this.a_end == 1.0) {
                return true;
            }
            this.b_start = this.a_start;
            this.a_start = MathHelper.approachLinear((double)this.a_start, (double)1.0, (double)0.2);
            this.b_end = this.a_end;
            if (this.liquid.amount > 0) {
                this.liquid.amount = Math.max(this.liquid.amount - (this.fast ? 200 : 20), 0);
                return this.liquid.amount == 0;
            }
            this.a_end = MathHelper.approachLinear((double)this.a_end, (double)1.0, (double)0.2);
            return false;
        }

        public void addLiquid(int moving) {
            if (this.liquid.amount == 0) {
                throw new IllegalArgumentException("Something went wrong!");
            }
            this.liquid.amount += moving;
            if (TileLiquidTranslocator.this.attachments[this.src] != null) {
                this.fast = TileLiquidTranslocator.this.attachments[this.src].fast;
            }
            this.capLiquid();
        }

        public void finish() {
            this.liquid.amount = 0;
        }
    }
}

