/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.api.helper;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import wanion.unidict.MetaItem;
import wanion.unidict.UniDict;

public final class FurnaceUniHelper
implements UniDict.IDependence {
    private final Map<ItemStack, ItemStack> furnaceRecipes = FurnaceRecipes.func_77602_a().func_77599_b();
    private final TIntObjectMap<List<ItemStack>> smartFurnaceRecipes = new TIntObjectHashMap();

    private FurnaceUniHelper() {
        this.populateSmartFurnaceRecipes();
    }

    public void remove(@Nonnull ItemStack itemStack) {
        this.remove(MetaItem.get(itemStack));
    }

    public void remove(int hash) {
        List furnaceInputStacks = (List)this.smartFurnaceRecipes.get(hash);
        if (furnaceInputStacks != null) {
            furnaceInputStacks.forEach(this.furnaceRecipes::remove);
            this.smartFurnaceRecipes.remove(hash);
        }
    }

    private void populateSmartFurnaceRecipes() {
        for (ItemStack furnaceInputStack : this.furnaceRecipes.keySet()) {
            int hash = MetaItem.get(furnaceInputStack);
            if (hash == 0) continue;
            ArrayList<ItemStack> furnaceInputStacks = !this.smartFurnaceRecipes.containsKey(hash) ? new ArrayList<ItemStack>() : (List)this.smartFurnaceRecipes.get(hash);
            furnaceInputStacks.add(furnaceInputStack);
            this.smartFurnaceRecipes.put(hash, furnaceInputStacks);
        }
    }
}

