/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.api.AEApi;
import appeng.api.util.WorldCoord;
import appeng.core.stats.Achievements;
import appeng.spatial.CachedPlane;
import appeng.spatial.ISpatialVisitor;
import appeng.spatial.StorageWorldProvider;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class StorageHelper {
    private static StorageHelper instance;

    public static StorageHelper getInstance() {
        if (instance == null) {
            instance = new StorageHelper();
        }
        return instance;
    }

    private Entity teleportEntity(Entity entity, TelDestination link) {
        boolean diffDestination;
        EntityPlayerMP player;
        WorldServer newWorld;
        WorldServer oldWorld;
        try {
            oldWorld = (WorldServer)entity.field_70170_p;
            newWorld = (WorldServer)link.dim;
            player = entity instanceof EntityPlayerMP ? (EntityPlayerMP)entity : null;
        }
        catch (Throwable e) {
            return entity;
        }
        if (oldWorld == null) {
            return entity;
        }
        if (newWorld == null) {
            return entity;
        }
        if (entity.field_70153_n != null) {
            return this.teleportEntity(entity.field_70153_n, link);
        }
        Entity cart = entity.field_70154_o;
        if (cart != null) {
            entity.func_70078_a(null);
            cart = this.teleportEntity(cart, link);
        }
        ((WorldServer)WorldServer.class.cast(newWorld)).func_72863_F().func_73158_c(MathHelper.func_76128_c((double)link.x) >> 4, MathHelper.func_76128_c((double)link.z) >> 4);
        boolean bl = diffDestination = newWorld != oldWorld;
        if (diffDestination) {
            if (player != null) {
                if (((TelDestination)link).dim.field_73011_w instanceof StorageWorldProvider) {
                    Achievements.SpatialIOExplorer.addToPlayer((EntityPlayer)player);
                }
                player.field_71133_b.func_71203_ab().transferPlayerToDimension(player, ((TelDestination)link).dim.field_73011_w.field_76574_g, (Teleporter)new METeleporter(newWorld, link));
            } else {
                Entity newEntity;
                int entX = entity.field_70176_ah;
                int entZ = entity.field_70164_aj;
                if (entity.field_70175_ag && oldWorld.func_72863_F().func_73149_a(entX, entZ)) {
                    oldWorld.func_72964_e(entX, entZ).func_76622_b(entity);
                    oldWorld.func_72964_e((int)entX, (int)entZ).field_76643_l = true;
                }
                if ((newEntity = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)entity), (World)newWorld)) != null) {
                    entity.field_70169_q = entity.field_70165_t = link.x;
                    entity.field_70142_S = entity.field_70165_t;
                    entity.field_70167_r = entity.field_70163_u = link.y;
                    entity.field_70137_T = entity.field_70163_u;
                    entity.field_70166_s = entity.field_70161_v = link.z;
                    entity.field_70136_U = entity.field_70161_v;
                    if (entity instanceof EntityHanging) {
                        EntityHanging h = (EntityHanging)entity;
                        h.field_146063_b += link.xOff;
                        h.field_146064_c += link.yOff;
                        h.field_146062_d += link.zOff;
                    }
                } else {
                    return null;
                }
                newEntity.func_82141_a(entity, true);
                newEntity.field_71093_bK = newWorld.field_73011_w.field_76574_g;
                newEntity.field_98038_p = true;
                entity.field_70128_L = true;
                entity = newEntity;
                newWorld.func_72838_d(entity);
            }
        }
        entity.field_70170_p.func_72866_a(entity, false);
        if (cart != null) {
            if (player != null) {
                entity.field_70170_p.func_72866_a(entity, true);
            }
            entity.func_70078_a(cart);
        }
        return entity;
    }

    private void transverseEdges(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, ISpatialVisitor visitor) {
        int x;
        int z;
        for (int y = minY; y < maxY; ++y) {
            for (z = minZ; z < maxZ; ++z) {
                visitor.visit(minX, y, z);
                visitor.visit(maxX, y, z);
            }
        }
        for (x = minX; x < maxX; ++x) {
            for (z = minZ; z < maxZ; ++z) {
                visitor.visit(x, minY, z);
                visitor.visit(x, maxY, z);
            }
        }
        for (x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                visitor.visit(x, y, minZ);
                visitor.visit(x, y, maxZ);
            }
        }
    }

    public void swapRegions(World src, World dst, int x, int y, int z, int i, int j, int k, int scaleX, int scaleY, int scaleZ) {
        for (Block matrixFrameBlock : AEApi.instance().definitions().blocks().matrixFrame().maybeBlock().asSet()) {
            this.transverseEdges(i - 1, j - 1, k - 1, i + scaleX + 1, j + scaleY + 1, k + scaleZ + 1, new WrapInMatrixFrame(matrixFrameBlock, 0, dst));
        }
        AxisAlignedBB srcBox = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + scaleX + 1), (double)(y + scaleY + 1), (double)(z + scaleZ + 1));
        AxisAlignedBB dstBox = AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)(i + scaleX + 1), (double)(j + scaleY + 1), (double)(k + scaleZ + 1));
        CachedPlane cDst = new CachedPlane(dst, i, j, k, i + scaleX, j + scaleY, k + scaleZ);
        CachedPlane cSrc = new CachedPlane(src, x, y, z, x + scaleX, y + scaleY, z + scaleZ);
        cSrc.swap(cDst);
        List srcE = src.func_72872_a(Entity.class, srcBox);
        List dstE = dst.func_72872_a(Entity.class, dstBox);
        for (Entity e : dstE) {
            this.teleportEntity(e, new TelDestination(src, srcBox, e.field_70165_t, e.field_70163_u, e.field_70161_v, -i + x, -j + y, -k + z));
        }
        for (Entity e : srcE) {
            this.teleportEntity(e, new TelDestination(dst, dstBox, e.field_70165_t, e.field_70163_u, e.field_70161_v, -x + i, -y + j, -z + k));
        }
        for (WorldCoord wc : cDst.getUpdates()) {
            cDst.getWorld().func_147460_e(wc.x, wc.y, wc.z, Platform.AIR_BLOCK);
        }
        for (WorldCoord wc : cSrc.getUpdates()) {
            cSrc.getWorld().func_147460_e(wc.x, wc.y, wc.z, Platform.AIR_BLOCK);
        }
        this.transverseEdges(x - 1, y - 1, z - 1, x + scaleX + 1, y + scaleY + 1, z + scaleZ + 1, new TriggerUpdates(src));
        this.transverseEdges(i - 1, j - 1, k - 1, i + scaleX + 1, j + scaleY + 1, k + scaleZ + 1, new TriggerUpdates(dst));
        this.transverseEdges(x, y, z, x + scaleX, y + scaleY, z + scaleZ, new TriggerUpdates(src));
        this.transverseEdges(i, j, k, i + scaleX, j + scaleY, k + scaleZ, new TriggerUpdates(dst));
    }

    private static class METeleporter
    extends Teleporter {
        private final TelDestination destination;

        public METeleporter(WorldServer par1WorldServer, TelDestination d) {
            super(par1WorldServer);
            this.destination = d;
        }

        public void func_77185_a(Entity par1Entity, double par2, double par4, double par6, float par8) {
            par1Entity.func_70012_b(this.destination.x, this.destination.y, this.destination.z, par1Entity.field_70177_z, 0.0f);
            par1Entity.field_70179_y = 0.0;
            par1Entity.field_70181_x = 0.0;
            par1Entity.field_70159_w = 0.0;
        }

        public boolean func_77184_b(Entity par1Entity, double par2, double par4, double par6, float par8) {
            return false;
        }

        public boolean func_85188_a(Entity par1Entity) {
            return false;
        }

        public void func_85189_a(long par1) {
        }
    }

    private static class TelDestination {
        private final World dim;
        private final double x;
        private final double y;
        private final double z;
        private final int xOff;
        private final int yOff;
        private final int zOff;

        TelDestination(World dimension, AxisAlignedBB srcBox, double x, double y, double z, int tileX, int tileY, int tileZ) {
            this.dim = dimension;
            this.x = Math.min(srcBox.field_72336_d - 0.5, Math.max(srcBox.field_72340_a + 0.5, x + (double)tileX));
            this.y = Math.min(srcBox.field_72337_e - 0.5, Math.max(srcBox.field_72338_b + 0.5, y + (double)tileY));
            this.z = Math.min(srcBox.field_72334_f - 0.5, Math.max(srcBox.field_72339_c + 0.5, z + (double)tileZ));
            this.xOff = tileX;
            this.yOff = tileY;
            this.zOff = tileZ;
        }
    }

    private static class WrapInMatrixFrame
    implements ISpatialVisitor {
        private final World dst;
        private final Block blkID;
        private final int Meta;

        public WrapInMatrixFrame(Block blockID, int metaData, World dst2) {
            this.dst = dst2;
            this.blkID = blockID;
            this.Meta = metaData;
        }

        @Override
        public void visit(int x, int y, int z) {
            this.dst.func_147465_d(x, y, z, this.blkID, this.Meta, 3);
        }
    }

    private static class TriggerUpdates
    implements ISpatialVisitor {
        private final World dst;

        public TriggerUpdates(World dst2) {
            this.dst = dst2;
        }

        @Override
        public void visit(int x, int y, int z) {
            Block blk = this.dst.func_147439_a(x, y, z);
            blk.func_149695_a(this.dst, x, y, z, Platform.AIR_BLOCK);
        }
    }
}

