/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.bag;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.FileVersion;
import hardcorequesting.QuestingData;
import hardcorequesting.SaveHelper;
import hardcorequesting.Translator;
import hardcorequesting.bag.BagTier;
import hardcorequesting.bag.GroupData;
import hardcorequesting.bag.GroupTier;
import hardcorequesting.client.EditMode;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiEditMenuItem;
import hardcorequesting.client.interfaces.GuiEditMenuTextEditor;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.ScrollBar;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.quests.ItemPrecision;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestLine;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

public class Group {
    private GroupTier tier;
    private List<ItemStack> items;
    private String name;
    private int limit;
    private int id;

    public static int size() {
        return QuestLine.getActiveQuestLine().groupCount;
    }

    private Group(int id, String name, GroupTier tier, List<ItemStack> items, int limit) {
        this.id = id;
        this.name = name;
        this.tier = tier;
        this.items = items;
        this.limit = limit;
        QuestLine.getActiveQuestLine().groupCount = Math.max(QuestLine.getActiveQuestLine().groupCount, id + 1);
    }

    public Group() {
        this.id = QuestLine.getActiveQuestLine().groupCount++;
        this.tier = GroupTier.getTiers().size() > 1 ? GroupTier.getTiers().get(1) : GroupTier.getTiers().get(0);
        this.items = new ArrayList<ItemStack>();
    }

    public GroupTier getTier() {
        return this.tier;
    }

    public static List<Group> getGroups() {
        return QuestLine.getActiveQuestLine().groupList;
    }

    public String getName() {
        return this.hasName() ? this.name : Translator.translate("hqm.bag.group", this.tier.getName());
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public void setTier(GroupTier tier) {
        this.tier = tier;
    }

    public void setItem(int id, ItemStack item) {
        if (id >= this.items.size()) {
            this.items.add(item);
            SaveHelper.add(SaveHelper.EditType.GROUP_ITEM_CREATE);
        } else {
            this.items.set(id, item);
            SaveHelper.add(SaveHelper.EditType.GROUP_ITEM_CHANGE);
        }
    }

    public void open(EntityPlayer player) {
        GroupData data;
        if (this.limit > 0 && (data = QuestingData.getQuestingData(player).getGroupData(this.id)) != null) {
            ++data.retrieved;
        }
        ArrayList<ItemStack> itemsToAdd = new ArrayList<ItemStack>();
        for (ItemStack item : this.items) {
            itemsToAdd.add(item.func_77946_l());
        }
        Quest.addItems(player, itemsToAdd);
        for (ItemStack item : itemsToAdd) {
            if (item.field_77994_a <= 0) continue;
            EntityItem entityItem = new EntityItem(player.field_70170_p, player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, item);
            player.field_70170_p.func_72838_d((Entity)entityItem);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void removeItem(int i) {
        if (i >= 0 && i < this.items.size()) {
            this.items.remove(i);
        }
    }

    public void remove(int i) {
        if (i >= 0 && i < QuestLine.getActiveQuestLine().groupList.size()) {
            Group group = QuestLine.getActiveQuestLine().groupList.remove(i);
            QuestLine.getActiveQuestLine().groups.remove(group.id);
        }
    }

    public static void saveAll(DataWriter dw) {
        dw.writeData(Group.getGroups().size(), DataBitHelper.GROUP_COUNT);
        for (Group group : Group.getGroups()) {
            dw.writeData(group.id, DataBitHelper.GROUP_COUNT);
            dw.writeString(group.name, DataBitHelper.QUEST_NAME_LENGTH);
            int id = GroupTier.getTiers().indexOf(group.tier);
            if (id == -1) {
                id = 0;
            }
            dw.writeData(id, DataBitHelper.TIER_COUNT);
            dw.writeData(group.items.size(), DataBitHelper.GROUP_ITEMS);
            for (ItemStack item : group.items) {
                dw.writeItemStack(item, true);
            }
            if (group.limit > 0) {
                dw.writeBoolean(true);
                dw.writeData(group.limit, DataBitHelper.LIMIT);
                continue;
            }
            dw.writeBoolean(false);
        }
    }

    public static void readAll(DataReader dr, FileVersion version) {
        QuestLine.getActiveQuestLine().groups.clear();
        QuestLine.getActiveQuestLine().groupList.clear();
        QuestLine.getActiveQuestLine().groupCount = 0;
        int count = dr.readData(DataBitHelper.GROUP_COUNT);
        for (int i = 0; i < count; ++i) {
            int id = i;
            if (version.contains(FileVersion.BAG_LIMITS)) {
                id = dr.readData(DataBitHelper.GROUP_COUNT);
            }
            String name = dr.readString(DataBitHelper.QUEST_NAME_LENGTH);
            GroupTier tier = GroupTier.getTiers().get(dr.readData(DataBitHelper.TIER_COUNT));
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            if (Quest.isEditing) {
                FMLLog.log((String)"HQM-EDIT", (Level)Level.INFO, (String)"Loading quest group %s", (Object[])new Object[]{name});
            }
            int itemCount = dr.readData(DataBitHelper.GROUP_ITEMS);
            for (int j = 0; j < itemCount; ++j) {
                ItemStack itemStack = dr.readItemStack(true);
                if (itemStack == null) continue;
                if (itemStack.func_77973_b() != null) {
                    items.add(itemStack);
                    continue;
                }
                FMLLog.log((String)"HQM", (Level)Level.ERROR, (String)"The bag item is invalid, skipping", (Object[])new Object[0]);
            }
            int limit = 0;
            if (version.contains(FileVersion.BAG_LIMITS) && dr.readBoolean()) {
                limit = dr.readData(DataBitHelper.LIMIT);
            }
            Group.add(new Group(id, name, tier, items, limit));
        }
    }

    public static void add(Group group) {
        QuestLine.getActiveQuestLine().groups.put(group.id, group);
        QuestLine.getActiveQuestLine().groupList.add(group);
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public static Group getGroup(int id) {
        return QuestLine.getActiveQuestLine().groups.get(id);
    }

    public int getRetrievalCount(EntityPlayer player) {
        GroupData data = QuestingData.getQuestingData(player).getGroupData(this.id);
        return data != null ? data.retrieved : 0;
    }

    public void setRetrievalCount(EntityPlayer player, int count) {
        GroupData data = QuestingData.getQuestingData(player).getGroupData(this.id);
        if (data != null) {
            data.retrieved = count;
        }
    }

    public boolean isValid(EntityPlayer player) {
        return this.limit == 0 || this.getRetrievalCount(player) < this.limit;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Group && Objects.equals(this.name, ((Group)obj).name) && this.limit == ((Group)obj).limit && this.items.size() == ((Group)obj).items.size()) {
            for (ItemStack stack : this.items) {
                if (this.listContains(stack, ((Group)obj).items)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean listContains(ItemStack stack, List<ItemStack> stacks) {
        for (ItemStack stack2 : stacks) {
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)stack2)) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawOverview(GuiQuestBook gui, ScrollBar tierScroll, ScrollBar groupScroll, int x, int y) {
        int start;
        List<GroupTier> tiers = GroupTier.getTiers();
        for (int i = start = tierScroll.isVisible(gui) ? Math.round((float)(tiers.size() - 8) * tierScroll.getScroll()) : 0; i < Math.min(start + 8, tiers.size()); ++i) {
            GroupTier groupTier = tiers.get(i);
            String str = groupTier.getName();
            int yPos = 20 + 25 * (i - start);
            boolean inBounds = gui.inBounds(180, yPos, gui.getStringWidth(str), 9, x, y);
            int color = groupTier.getColor().getHexColor();
            if (inBounds) {
                color &= 0xFFFFFF;
                color |= 0xBB000000;
                GL11.glEnable((int)3042);
            }
            gui.drawString(str, 180, yPos, color);
            if (inBounds) {
                GL11.glDisable((int)3042);
            }
            for (int j = 0; j < BagTier.values().length; ++j) {
                BagTier bagTier = BagTier.values()[j];
                gui.drawCenteredString(bagTier.getColor().toString() + groupTier.getWeights()[j], 175 + j * 25, yPos + 12, 0.7f, 25, 0, 0x404040);
            }
        }
        List<Group> groups = Group.getGroups();
        for (int i = start = groupScroll.isVisible(gui) ? Math.round((float)(groups.size() - 8) * groupScroll.getScroll()) : 0; i < Math.min(start + 8, groups.size()); ++i) {
            boolean selected;
            Group group = groups.get(i);
            String str = group.getName();
            int yPos = 20 + 25 * (i - start);
            boolean inBounds = gui.inBounds(20, yPos, gui.getStringWidth(str), 9, x, y);
            int color = group.getTier().getColor().getHexColor();
            boolean bl = selected = group == gui.modifyingGroup;
            if (inBounds || selected) {
                color &= 0xFFFFFF;
                GL11.glEnable((int)3042);
                color = selected ? (color |= 0x50000000) : (color |= 0xBB000000);
            }
            gui.drawString(str, 20, yPos, color);
            if (inBounds || selected) {
                GL11.glDisable((int)3042);
            }
            gui.drawString(Translator.translate("hqm.questBook.items", group.getItems().size()), 25, yPos + 12, 0.7f, 0x404040);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiQuestBook gui, int x, int y) {
        int yPos;
        int xPos;
        ItemStack itemStack;
        int i;
        gui.drawString(this.getName(), 20, 20, this.getTier().getColor().getHexColor());
        List<ItemStack> items = this.getItems();
        for (i = 0; i < Math.min(DataBitHelper.GROUP_ITEMS.getMaximum(), items.size() + 1); ++i) {
            itemStack = i < items.size() ? items.get(i) : null;
            xPos = i % 7 * 20 + 20;
            yPos = i / 7 * 20 + 40;
            gui.drawItem(itemStack, xPos, yPos, x, y, false);
        }
        for (i = 0; i < items.size(); ++i) {
            itemStack = items.get(i);
            xPos = i % 7 * 20 + 20;
            yPos = i / 7 * 20 + 40;
            if (!gui.inBounds(xPos, yPos, 18, 18, x, y)) continue;
            if (itemStack == null || itemStack.func_77973_b() == null) break;
            try {
                gui.drawMouseOver(itemStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x), x + gui.getLeft(), y + gui.getTop());
            }
            catch (Exception exception) {}
            break;
        }
        gui.drawString(Translator.translate("hqm.questBook.maxRetrieval"), 180, 20, 0x404040);
        gui.drawString(Translator.translate("hqm.questBook.noRestriction"), 180, 48, 0.7f, 0x404040);
    }

    @SideOnly(value=Side.CLIENT)
    public void mouseClicked(GuiQuestBook gui, int x, int y) {
        List<ItemStack> items = this.getItems();
        for (int i = 0; i < Math.min(DataBitHelper.GROUP_ITEMS.getMaximum(), items.size() + 1); ++i) {
            int xPos = i % 7 * 20 + 20;
            int yPos = i / 7 * 20 + 40;
            if (!gui.inBounds(xPos, yPos, 18, 18, x, y)) continue;
            if (gui.getCurrentMode() == EditMode.ITEM) {
                int amount;
                ItemStack itemStack;
                ItemStack itemStack2 = itemStack = i < items.size() ? items.get(i) : null;
                if (itemStack != null) {
                    itemStack = itemStack.func_77946_l();
                    amount = itemStack.field_77994_a;
                } else {
                    amount = 1;
                }
                gui.setEditMenu(new GuiEditMenuItem((GuiBase)gui, gui.getPlayer(), itemStack, i, GuiEditMenuItem.Type.BAG_ITEM, amount, ItemPrecision.PRECISE));
                break;
            }
            if (gui.getCurrentMode() != EditMode.DELETE) break;
            this.removeItem(i);
            SaveHelper.add(SaveHelper.EditType.GROUP_ITEM_REMOVE);
            break;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void mouseClickedOverview(GuiQuestBook gui, ScrollBar groupScroll, int x, int y) {
        int start;
        List<Group> groups = Group.getGroups();
        for (int i = start = groupScroll.isVisible(gui) ? Math.round((float)(groups.size() - 8) * groupScroll.getScroll()) : 0; i < Math.min(start + 8, groups.size()); ++i) {
            int posY = 20 + 25 * (i - start);
            Group group = groups.get(i);
            if (!gui.inBounds(20, posY, gui.getStringWidth(group.getName()), 9, x, y)) continue;
            switch (gui.getCurrentMode()) {
                case TIER: {
                    gui.modifyingGroup = group == gui.modifyingGroup ? null : group;
                    break;
                }
                case NORMAL: {
                    GuiQuestBook.selectedGroup = group;
                    gui.getTextBoxGroupAmount().setTextAndCursor(gui, String.valueOf(GuiQuestBook.getSelectedGroup().getLimit()));
                    break;
                }
                case RENAME: {
                    gui.setEditMenu(new GuiEditMenuTextEditor(gui, gui.getPlayer(), group));
                    break;
                }
                case DELETE: {
                    group.remove(i);
                    SaveHelper.add(SaveHelper.EditType.GROUP_REMOVE);
                    break;
                }
            }
            break;
        }
    }
}

