/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.api.ITeleportPipe;
import buildcraft.additionalpipes.api.PipeType;
import buildcraft.additionalpipes.api.TeleportManagerBase;
import buildcraft.additionalpipes.pipes.PipeTeleport;
import buildcraft.additionalpipes.pipes.PipeTransportItemsLogistics;
import buildcraft.additionalpipes.utils.Log;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.PipeTransportPower;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.World;

public class TeleportManager
extends TeleportManagerBase {
    public static final TeleportManager instance = new TeleportManager();
    public final Multimap<Integer, PipeTeleport<PipeTransportItems>> itemPipes = LinkedListMultimap.create();
    public final Multimap<Integer, PipeTeleport<PipeTransportFluids>> fluidPipes = LinkedListMultimap.create();
    public final Multimap<Integer, PipeTeleport<PipeTransportPower>> powerPipes = LinkedListMultimap.create();
    public final Multimap<Integer, PipeTeleport<PipeTransportItemsLogistics>> logisticsPipes = LinkedListMultimap.create();
    public final Map<Integer, String> frequencyNames = new HashMap<Integer, String>();

    private TeleportManager() {
    }

    private Collection getPipesInChannel(int frequency, PipeType type) {
        switch (type) {
            case ITEMS: {
                return this.itemPipes.get((Object)frequency);
            }
            case FLUIDS: {
                return this.fluidPipes.get((Object)frequency);
            }
            case POWER: {
                return this.powerPipes.get((Object)frequency);
            }
            case LOGISTICS: {
                return this.logisticsPipes.get((Object)frequency);
            }
        }
        return null;
    }

    @Override
    public void add(ITeleportPipe pipe, int frequency) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return;
        }
        switch (pipe.getType()) {
            case ITEMS: {
                this.itemPipes.put((Object)frequency, (Object)((PipeTeleport)pipe));
                break;
            }
            case FLUIDS: {
                this.fluidPipes.put((Object)frequency, (Object)((PipeTeleport)pipe));
                break;
            }
            case POWER: {
                this.powerPipes.put((Object)frequency, (Object)((PipeTeleport)pipe));
                break;
            }
            case LOGISTICS: {
                this.logisticsPipes.put((Object)frequency, (Object)((PipeTeleport)pipe));
            }
        }
        if (pipe.getContainer() != null) {
            Log.debug(String.format("[TeleportManager] Pipe added: %s @ (%.1f, %.1f, %.1f), %d pipes in channel", pipe.getType().toString().toLowerCase(), pipe.getPosition().x, pipe.getPosition().y, pipe.getPosition().z, this.getPipesInChannel(frequency, pipe.getType()).size()));
        }
    }

    @Override
    public void remove(ITeleportPipe pipe, int frequency) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return;
        }
        switch (pipe.getType()) {
            case ITEMS: {
                this.itemPipes.remove((Object)frequency, (Object)((PipeTeleport)pipe));
                break;
            }
            case FLUIDS: {
                this.fluidPipes.remove((Object)frequency, (Object)((PipeTeleport)pipe));
                break;
            }
            case POWER: {
                this.powerPipes.remove((Object)frequency, (Object)((PipeTeleport)pipe));
                break;
            }
            case LOGISTICS: {
                this.logisticsPipes.remove((Object)frequency, (Object)((PipeTeleport)pipe));
            }
        }
        if (pipe.getContainer() != null) {
            Log.debug(String.format("[TeleportManager] Pipe removed: %s @ (%.1f, %.1f, %.1f), %d pipes in channel", pipe.getType().toString().toLowerCase(), pipe.getPosition().x, pipe.getPosition().y, pipe.getPosition().z, this.getPipesInChannel(frequency, pipe.getType()).size()));
        }
    }

    @Override
    public void reset() {
        this.itemPipes.clear();
        this.fluidPipes.clear();
        this.powerPipes.clear();
        this.logisticsPipes.clear();
        this.frequencyNames.clear();
        Log.info("Reset teleport manager.");
    }

    @Override
    public <T extends ITeleportPipe> ArrayList<T> getConnectedPipes(T pipe, boolean includeSend, boolean includeReceive) {
        Collection channel = this.getPipesInChannel(pipe.getFrequency(), pipe.getType());
        ArrayList<ITeleportPipe> connected = new ArrayList<ITeleportPipe>();
        for (ITeleportPipe other : channel) {
            if (other.getContainer() != null && other.getContainer().func_145837_r() || pipe == other || (!other.canReceive() || !includeReceive) && (!other.canSend() || !includeSend) || !(pipe.isPublic() ? other.isPublic() : other.getOwnerUUID() != null && other.getOwnerUUID().equals(pipe.getOwnerUUID()))) continue;
            connected.add(other);
        }
        return connected;
    }

    public Collection<PipeTeleport<PipeTransportItems>> getAllItemPipesInNetwork() {
        return this.itemPipes.values();
    }

    public Collection<PipeTeleport<PipeTransportFluids>> getAllFluidPipesInNetwork() {
        return this.fluidPipes.values();
    }

    public Collection<PipeTeleport<PipeTransportPower>> getAllPowerPipesInNetwork() {
        return this.powerPipes.values();
    }

    public Collection<PipeTeleport<PipeTransportItemsLogistics>> getAllLogisticsPipesInNetwork() {
        return this.logisticsPipes.values();
    }

    @Override
    public String getFrequencyName(int frequency) {
        String name = this.frequencyNames.get(frequency);
        return name == null ? "" : name;
    }

    @Override
    public void setFrequencyName(int frequency, String name) {
        this.frequencyNames.put(frequency, name);
    }

    public File getWorldSave(World world) {
        return world.func_72860_G().func_75758_b("foo").getParentFile().getParentFile();
    }
}

