/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Helpers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.util.IIcon;
import vswe.stevescarts.Helpers.ResourceHelper;
import vswe.stevescarts.Interfaces.GuiDetector;

@SideOnly(value=Side.CLIENT)
public class DropDownMenu {
    public static final int SCROLL_HEIGHT = 170;
    public static final int SCROLL_HEADER_HEIGHT = 14;
    public static final int SCROLL_TOP_MARGIN = 20;
    public static final int TAB_COUNT = 3;
    private int moduleScroll;
    private int index;
    private boolean forceGoUp;

    public DropDownMenu(int index) {
        this.index = index;
        this.moduleScroll = 0;
    }

    public static void update(GuiDetector gui, int x, int y, ArrayList<DropDownMenu> menus) {
        if (gui.currentObject == null) {
            for (DropDownMenu menu : menus) {
                if (!gui.inRect(x, y, menu.getHeaderRect())) continue;
                menu.forceGoUp = false;
                menu.update(true);
                for (DropDownMenu menu2 : menus) {
                    if (menu.equals(menu2)) continue;
                    menu2.forceGoUp = true;
                    menu2.update(false);
                }
                return;
            }
            for (DropDownMenu menu : menus) {
                menu.update(gui.inRect(x, y, menu.getMainRect()));
            }
        } else {
            for (DropDownMenu menu : menus) {
                menu.update(false);
            }
        }
    }

    private void update(boolean hasFocus) {
        if (!this.forceGoUp && hasFocus) {
            if (this.moduleScroll < 156) {
                this.moduleScroll += 10;
                if (this.moduleScroll > 156) {
                    this.moduleScroll = 156;
                }
            }
        } else if (this.moduleScroll > 0) {
            this.moduleScroll -= 25;
            if (this.moduleScroll <= 0) {
                this.moduleScroll = 0;
                this.forceGoUp = false;
            }
        }
    }

    public void drawMain(GuiDetector gui, int x, int y) {
        ResourceHelper.bindResource(GuiDetector.dropdownTexture);
        int[] rect = this.getMainRect();
        gui.func_73729_b(gui.getGuiLeft() + rect[0], gui.getGuiTop() + rect[1], 0, 156 - this.moduleScroll, rect[2], rect[3]);
    }

    public void drawHeader(GuiDetector gui) {
        ResourceHelper.bindResource(GuiDetector.dropdownTexture);
        int[] rect = this.getHeaderRect();
        gui.func_73729_b(gui.getGuiLeft() + rect[0], gui.getGuiTop() + rect[1], 77 * this.index, 156, rect[2], rect[3]);
    }

    public void drawContent(GuiDetector gui, int index, int srcX, int srcY) {
        int[] rect = this.getContentRect(index);
        if (rect == null) {
            return;
        }
        int gap = rect[1] - this.getMainRect()[1] + rect[3];
        if (gap > 0) {
            int height = Math.min(rect[3], gap);
            int offset = rect[3] - height;
            gui.func_73729_b(gui.getGuiLeft() + rect[0], gui.getGuiTop() + rect[1] + offset, srcX, srcY + offset, rect[2], height);
        }
    }

    public void drawContent(GuiDetector gui, int index, IIcon icon) {
        int[] rect = this.getContentRect(index);
        if (rect == null) {
            return;
        }
        int gap = rect[1] - this.getMainRect()[1] + rect[3];
        if (gap > 0) {
            int height = Math.min(rect[3], gap);
            int offset = rect[3] - height;
            gui.drawIcon(icon, gui.getGuiLeft() + rect[0], gui.getGuiTop() + rect[1] + offset, (float)rect[2] / 16.0f, (float)height / 16.0f, 0.0f, (float)offset / 16.0f);
        }
    }

    public int[] getContentRect(int posId) {
        int objectsPerRow = 11;
        int objectsRows = 7;
        int objectWidth = 16;
        int objectHeight = 16;
        int objectY = 31;
        if (this.index == 2) {
            objectsPerRow = 9;
            objectsRows = 10;
            objectWidth = 20;
            objectHeight = 11;
            objectY = 34;
        }
        if ((posId = this.getCurrentId(posId, objectsPerRow * objectsRows)) < 0 || posId >= objectsPerRow * objectsRows) {
            return null;
        }
        int x = posId % objectsPerRow;
        int y = posId / objectsPerRow;
        int targetX = x * (objectWidth + 3) + 25;
        int targetY = y * (objectHeight + 3) + 20 + objectY + this.getScroll() - 170;
        return new int[]{targetX, targetY, objectWidth, objectHeight};
    }

    public int[] getMainRect() {
        return new int[]{11, 20, 232, this.moduleScroll};
    }

    public int[] getHeaderRect() {
        return new int[]{11 + 77 * this.index, 20 + this.moduleScroll, (int)Math.ceil(77.33333587646484), 14};
    }

    public int getScroll() {
        return this.moduleScroll;
    }

    protected int getCurrentId(int index, int objects) {
        return index;
    }

    public void onClick(GuiDetector gui, int x, int y) {
    }
}

