/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.mod.handlers;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import ftb.lib.BlockDimPos;
import ftb.lib.EntityPos;
import ftb.lib.FTBLib;
import ftb.lib.LMDimUtils;
import ftb.lib.api.notification.Notification;
import ftb.utils.api.EventLMPlayerServer;
import ftb.utils.mod.FTBU;
import ftb.utils.mod.config.FTBUConfigGeneral;
import ftb.utils.mod.handlers.FTBUChunkEventHandler;
import ftb.utils.net.MessageLMPlayerDied;
import ftb.utils.net.MessageLMPlayerLoggedOut;
import ftb.utils.world.LMPlayerServer;
import ftb.utils.world.LMWorldServer;
import ftb.utils.world.claims.ChunkType;
import ftb.utils.world.claims.ClaimedChunks;
import latmod.lib.MathHelperLM;
import latmod.lib.util.Pos2I;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class FTBUPlayerEventHandler {
    @SubscribeEvent
    public void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent e) {
        if (e.player instanceof EntityPlayerMP) {
            FTBUPlayerEventHandler.playerLoggedOut((EntityPlayerMP)e.player);
        }
    }

    public static void playerLoggedOut(EntityPlayerMP ep) {
        LMPlayerServer p = LMWorldServer.inst.getPlayer(ep);
        if (p == null) {
            return;
        }
        p.refreshStats();
        for (int i = 0; i < 4; ++i) {
            p.lastArmor[i] = ep.field_71071_by.field_70460_b[i];
        }
        p.lastArmor[4] = ep.field_71071_by.func_70448_g();
        new EventLMPlayerServer.LoggedOut(p, ep).post();
        new MessageLMPlayerLoggedOut(p).sendTo(null);
        p.setPlayer(null);
        FTBUChunkEventHandler.instance.markDirty(null);
    }

    @SubscribeEvent
    public void onChunkChanged(EntityEvent.EnteringChunk e) {
        if (e.entity.field_70170_p.field_72995_K || !(e.entity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP ep = (EntityPlayerMP)e.entity;
        LMPlayerServer player = LMWorldServer.inst.getPlayer(ep);
        if (player == null || !player.isOnline()) {
            return;
        }
        player.lastPos = new EntityPos((Entity)ep).toLinkedPos();
        if (LMWorldServer.inst.settings.getWB(ep.field_71093_bK).isOutsideD(ep.field_70165_t, ep.field_70161_v)) {
            ep.field_70179_y = 0.0;
            ep.field_70181_x = 0.0;
            ep.field_70159_w = 0.0;
            IChatComponent warning = FTBU.mod.chatComponent(ChunkType.WORLD_BORDER.lang + ".warning", new Object[0]);
            warning.func_150256_b().func_150238_a(EnumChatFormatting.WHITE);
            Notification n = new Notification("world_border", warning, 3000);
            n.color = ChunkType.WORLD_BORDER.getAreaColor(player);
            FTBLib.notifyPlayer((EntityPlayerMP)ep, (Notification)n);
            if (LMWorldServer.inst.settings.getWB(player.lastPos.dim).isOutsideD(player.lastPos.x, player.lastPos.z)) {
                FTBLib.printChat((ICommandSender)ep, (Object)FTBU.mod.chatComponent("cmd.spawn_tp", new Object[0]));
                World w = LMDimUtils.getWorld((int)0);
                Pos2I pos = LMWorldServer.inst.settings.getWB((int)0).pos;
                int posY = w.func_72825_h(pos.x, pos.y);
                LMDimUtils.teleportPlayer((Entity)ep, (double)((double)pos.x + 0.5), (double)((double)posY + 1.25), (double)((double)pos.y + 0.5), (int)0);
            } else {
                LMDimUtils.teleportPlayer((Entity)ep, (BlockDimPos)player.lastPos);
            }
            ep.field_70170_p.func_72956_a((Entity)ep, "random.fizz", 1.0f, 1.0f);
        }
        int currentChunkType = LMWorldServer.inst.claimedChunks.getType((int)ep.field_71093_bK, (int)e.newChunkX, (int)e.newChunkZ).ID;
        if (player.lastChunkType == -99 || player.lastChunkType != currentChunkType) {
            player.lastChunkType = currentChunkType;
            ChunkType type = ClaimedChunks.getChunkTypeFromI(currentChunkType);
            Object msg = null;
            msg = type.isClaimed() ? new ChatComponentText(String.valueOf(LMWorldServer.inst.getPlayer(currentChunkType))) : FTBU.mod.chatComponent(type.lang, new Object[0]);
            msg.func_150256_b().func_150238_a(EnumChatFormatting.WHITE);
            msg.func_150256_b().func_150227_a(Boolean.valueOf(true));
            Notification n = new Notification("chunk_changed", msg, 3000);
            n.setColor(type.getAreaColor(player));
            FTBLib.notifyPlayer((EntityPlayerMP)ep, (Notification)n);
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent e) {
        if (e.entity instanceof EntityPlayerMP) {
            LMPlayerServer p = LMWorldServer.inst.getPlayer(e.entity);
            p.lastDeath = new EntityPos(e.entity).toLinkedPos();
            p.refreshStats();
            new MessageLMPlayerDied(p).sendTo(null);
        }
    }

    @SubscribeEvent
    public void onPlayerAttacked(LivingAttackEvent e) {
        if (e.entity.field_70170_p.field_72995_K) {
            return;
        }
        int dim = e.entity.field_71093_bK;
        if (dim != 0 || !(e.entity instanceof EntityPlayerMP) || e.entity instanceof FakePlayer) {
            return;
        }
        Entity entity = e.source.func_76364_f();
        if (entity != null && (entity instanceof EntityPlayerMP || entity instanceof IMob)) {
            if (entity instanceof FakePlayer) {
                return;
            }
            if (entity instanceof EntityPlayerMP && LMWorldServer.inst.getPlayer(entity).allowInteractSecure()) {
                return;
            }
            int cx = MathHelperLM.chunk((double)e.entity.field_70165_t);
            int cz = MathHelperLM.chunk((double)e.entity.field_70161_v);
            if (FTBUConfigGeneral.safe_spawn.get() && ClaimedChunks.isInSpawn(dim, cx, cz)) {
                e.setCanceled(true);
            }
        }
    }
}

