/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.world.claims;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.utils.world.LMPlayerClient;
import ftb.utils.world.LMPlayerServer;
import ftb.utils.world.LMWorldClient;
import ftb.utils.world.LMWorldServer;
import latmod.lib.Bits;
import latmod.lib.LMUtils;
import latmod.lib.MathHelperLM;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.ChunkCoordIntPair;

public final class ClaimedChunk {
    public final int posX;
    public final int posZ;
    public final int ownerID;
    public final int dim;
    public boolean isChunkloaded = false;
    public boolean isForced = false;

    public ClaimedChunk(int o, int d, int x, int z) {
        this.posX = x;
        this.posZ = z;
        this.ownerID = o;
        this.dim = d;
    }

    public ClaimedChunk(EntityPlayer ep) {
        this(LMWorldServer.inst.getPlayer(ep).getPlayerID(), ep.field_71093_bK, MathHelperLM.chunk((double)ep.field_70165_t), MathHelperLM.chunk((double)ep.field_70161_v));
    }

    public Long getLongPos() {
        return Bits.intsToLong((int)this.posX, (int)this.posZ);
    }

    public LMPlayerServer getOwnerS() {
        return LMWorldServer.inst.getPlayer(this.ownerID);
    }

    @SideOnly(value=Side.CLIENT)
    public LMPlayerClient getOwnerC() {
        return LMWorldClient.inst.getPlayer(this.ownerID);
    }

    public boolean equals(Object o) {
        return o != null && (o == this || o instanceof ClaimedChunk && this.equalsChunk((ClaimedChunk)o));
    }

    public boolean equalsChunk(int d, int x, int z) {
        return this.dim == d && this.posX == x && this.posZ == z;
    }

    public boolean equalsChunk(ClaimedChunk c) {
        return this.equalsChunk(c.dim, c.posX, c.posZ);
    }

    public String toString() {
        return "[" + this.dim + ',' + this.posX + ',' + this.posZ + ']';
    }

    public int hashCode() {
        return LMUtils.hashCode((Object[])new Object[]{this.dim, this.posX, this.posZ});
    }

    public double getDistSq(double x, double z) {
        double x0 = (double)MathHelperLM.unchunk((int)this.posX) + 8.5;
        double z0 = (double)MathHelperLM.unchunk((int)this.posZ) + 8.5;
        return MathHelperLM.distSq((double)x0, (double)0.0, (double)z0, (double)x, (double)0.0, (double)z);
    }

    public double getDistSq(ClaimedChunk c) {
        return this.getDistSq((double)MathHelperLM.unchunk((int)c.posX) + 8.5, (double)MathHelperLM.unchunk((int)c.posZ) + 8.5);
    }

    public ChunkCoordIntPair getPos() {
        return new ChunkCoordIntPair(this.posX, this.posZ);
    }
}

