/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.arboriculture.tiles.TileFruitPod;
import forestry.core.render.TextureManager;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.plugins.PluginArboriculture;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFruitPod
extends BlockCocoa {
    @SideOnly(value=Side.CLIENT)
    private static IIcon defaultIcon;

    public static TileFruitPod getPodTile(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileFruitPod)) {
            return null;
        }
        return (TileFruitPod)tile;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
            return;
        }
        TileFruitPod tile = BlockFruitPod.getPodTile((IBlockAccess)world, x, y, z);
        if (tile == null) {
            return;
        }
        tile.onBlockTick();
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        TileFruitPod tile;
        if (!world.field_72995_K && (tile = BlockFruitPod.getPodTile((IBlockAccess)world, x, y, z)) != null) {
            for (ItemStack drop : tile.getDrop()) {
                ItemStackUtil.dropItemStackAsEntity(drop, world, x, y, z);
            }
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return BlockUtil.getDirectionalMetadata(world, x, y, z) >= 0;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        world.func_147475_p(x, y, z);
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileFruitPod();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        defaultIcon = TextureManager.registerTex(register, "pods/papaya.2");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        return defaultIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        IIcon podIcon;
        TileFruitPod pod = BlockFruitPod.getPodTile(world, x, y, z);
        if (pod != null && (podIcon = pod.getIcon()) != null) {
            return podIcon;
        }
        return defaultIcon;
    }

    public int func_149645_b() {
        return PluginArboriculture.modelIdPods;
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean isClient) {
        TileFruitPod podTile = BlockFruitPod.getPodTile((IBlockAccess)world, x, y, z);
        if (podTile != null) {
            return podTile.canMature();
        }
        return false;
    }

    public boolean func_149852_a(World world, Random random, int x, int y, int z) {
        return true;
    }

    public void func_149853_b(World world, Random random, int x, int y, int z) {
        TileFruitPod podTile = BlockFruitPod.getPodTile((IBlockAccess)world, x, y, z);
        if (podTile != null) {
            podTile.mature();
        }
    }
}

