/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.api.imc;

import cpw.mods.fml.common.event.FMLInterModComms;
import erogenousbeef.bigreactors.common.BRLog;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class MessageRouter {
    protected static Map<String, Method> handlers = new HashMap<String, Method>();

    public static void route(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            Method handler = handlers.get(message.key);
            if (handler != null) {
                try {
                    handler.invoke((Object)message, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    BRLog.warning("IllegalAccessException while handling message <%s>, ignoring. Error: %s", message.key, e.getMessage());
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    BRLog.warning("IllegalArgumentException while handling message <%s>, ignoring. Error: %s", message.key, e.getMessage());
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    BRLog.warning("InvocationTargetException while handling message <%s>, ignoring. Error: %s", message.key, e.getMessage());
                    e.printStackTrace();
                }
                continue;
            }
            BRLog.warning("Received an InterModComms event with an unrecognized key <%s>", message.key);
        }
    }

    public static void register(String key, Method handler) {
        handlers.put(key, handler);
    }
}

