/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities.energynet;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.client.render.particle.ParticleEnergyField;
import com.brandon3055.draconicevolution.common.items.tools.Wrench;
import com.brandon3055.draconicevolution.common.tileentities.energynet.TileRemoteEnergyBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEnergyTransceiver
extends TileRemoteEnergyBase {
    public int facing = 0;
    private boolean input = false;
    public boolean transferBoost = false;
    @SideOnly(value=Side.CLIENT)
    private ParticleEnergyField particle;

    public TileEnergyTransceiver() {
    }

    public TileEnergyTransceiver(int powerTier) {
        this.powerTier = powerTier;
        this.updateStorage();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            ForgeDirection direction = ForgeDirection.getOrientation((int)this.facing).getOpposite();
            TileEntity adjacentTile = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            if (!this.input && adjacentTile instanceof IEnergyReceiver) {
                IEnergyReceiver handler = (IEnergyReceiver)adjacentTile;
                this.storage.extractEnergy(handler.receiveEnergy(direction.getOpposite(), this.storage.extractEnergy(this.storage.getMaxExtract(), true), false), false);
                if (this.transferBoost) {
                    for (int i = 0; i < 4; ++i) {
                        this.storage.extractEnergy(handler.receiveEnergy(direction.getOpposite(), this.storage.extractEnergy(this.storage.getMaxExtract(), true), false), false);
                    }
                }
            } else if (this.input && adjacentTile instanceof IEnergyProvider) {
                IEnergyProvider handler = (IEnergyProvider)adjacentTile;
                if (this.transferBoost) {
                    for (int i = 0; i < 4; ++i) {
                        this.storage.receiveEnergy(handler.extractEnergy(direction.getOpposite(), this.storage.receiveEnergy(this.storage.getMaxExtract(), true), false), false);
                    }
                }
            }
        }
        if (this.field_145850_b.field_72995_K) {
            this.particle = DraconicEvolution.proxy.energyField(this.field_145850_b, this.getBeamX(), this.getBeamY(), this.getBeamZ(), 1, this.powerTier == 1, this.particle, this.inView > 0);
        }
    }

    @Override
    public boolean handleOther(EntityPlayer player, ItemStack wrench) {
        String mode = Wrench.getMode(wrench);
        if (mode.equals("modeSwitch")) {
            if (this.powerTier == 0) {
                this.input = !this.input;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else if (!this.transferBoost) {
                this.transferBoost = true;
            } else {
                this.input = !this.input;
                this.transferBoost = false;
            }
        }
        return true;
    }

    public boolean getInput() {
        return this.input;
    }

    public void setInput(boolean input) {
        this.input = input;
    }

    @Override
    public double getBeamX() {
        return (double)this.field_145851_c + 0.5;
    }

    @Override
    public double getBeamY() {
        return (double)this.field_145848_d + 0.5;
    }

    @Override
    public double getBeamZ() {
        return (double)this.field_145849_e + 0.5;
    }

    @Override
    public int getCap() {
        return this.powerTier == 0 ? 50000 : 10000000;
    }

    @Override
    public int getRec() {
        return this.powerTier == 0 ? 50000 : 10000000;
    }

    @Override
    public int getExt() {
        return this.powerTier == 0 ? 50000 : 10000000;
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("Facing", this.facing);
        compound.func_74757_a("Input", this.input);
        compound.func_74757_a("TransferBoost", this.transferBoost);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.facing = compound.func_74762_e("Facing");
        this.input = compound.func_74767_n("Input");
        this.transferBoost = compound.func_74767_n("TransferBoost");
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from == ForgeDirection.getOrientation((int)this.facing).getOpposite();
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return from == ForgeDirection.getOrientation((int)this.facing).getOpposite() && this.input ? this.storage.receiveEnergy(maxReceive, simulate) : 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return from == ForgeDirection.getOrientation((int)this.facing).getOpposite() && !this.input ? this.storage.extractEnergy(maxExtract, simulate) : 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public int getMaxConnections() {
        return this.powerTier == 0 ? 2 : 4;
    }
}

