/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.converter.inbound;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import openperipheral.api.converter.IConverter;
import openperipheral.converter.TypeConverter;

public abstract class ContainerConverterHelper<R> {
    private final int offset;

    public ContainerConverterHelper(int offset) {
        this.offset = offset;
    }

    public R convertToContainer(IConverter registry, Object obj, TypeToken<?> type) {
        TypeToken<?> componentType = this.getComponentType(type);
        Map m = (Map)obj;
        if (m.isEmpty()) {
            return this.createEmptyContainer(componentType);
        }
        int indexMax = Integer.MIN_VALUE;
        HashMap tmp = Maps.newHashMap();
        for (Map.Entry e : m.entrySet()) {
            Object k = e.getKey();
            Preconditions.checkArgument((boolean)(k instanceof Number), (String)"Key '%s' is not number", (Object[])new Object[]{k});
            int index = ((Number)k).intValue();
            Preconditions.checkArgument((index >= this.offset ? 1 : 0) != 0, (String)"Indices must be larger than %s, got %s", (Object[])new Object[]{this.offset, index});
            if ((index -= this.offset) > indexMax) {
                indexMax = index;
            }
            tmp.put(index, e.getValue());
        }
        Type valueType = componentType.getType();
        boolean isNullable = componentType.isPrimitive();
        int size = indexMax + 1;
        R result = this.createNewContainer(componentType, size);
        for (int i = 0; i < size; ++i) {
            Object o = tmp.get(i);
            if (o == null) continue;
            Object converted = TypeConverter.nullableToJava(registry, isNullable, o, valueType);
            this.setResult(result, i, converted);
        }
        return result;
    }

    protected abstract TypeToken<?> getComponentType(TypeToken<?> var1);

    protected abstract R createEmptyContainer(TypeToken<?> var1);

    protected abstract R createNewContainer(TypeToken<?> var1, int var2);

    protected abstract void setResult(R var1, int var2, Object var3);
}

