/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.tileentity.peripheral.method;

import com.InfinityRaider.AgriCraft.api.v2.ITrowel;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.farming.cropplant.CropPlant;
import com.InfinityRaider.AgriCraft.items.ItemJournal;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityCrop;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.TileEntityPeripheral;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.IMethod;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.MethodException;
import com.InfinityRaider.AgriCraft.tileentity.peripheral.method.MethodParameter;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class MethodBase
implements IMethod {
    private final String name;

    public MethodBase(String name) {
        this.name = name;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Object[] call(TileEntityPeripheral peripheral, World world, int x, int y, int z, ItemStack journal, Object ... args) throws MethodException {
        if (this.appliesToPeripheral() && (args == null || args.length == 0)) {
            return this.callMethodForPeripheral(peripheral, journal);
        }
        if (this.appliesToCrop()) {
            ForgeDirection dir = this.getDirection(args);
            if (dir == ForgeDirection.UNKNOWN) {
                throw new MethodException(this, "Invalid direction");
            }
            TileEntity tile = world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            if (tile == null || !(tile instanceof TileEntityCrop)) {
                throw new MethodException(this, "There is no crop there");
            }
            TileEntityCrop crop = (TileEntityCrop)tile;
            return this.callMethodForCrop(crop, journal);
        }
        throw new MethodException(this, "Invalid arguments");
    }

    private ForgeDirection getDirection(Object ... args) {
        for (Object obj : args) {
            ForgeDirection dir = ForgeDirection.UNKNOWN;
            if (obj == null) continue;
            if (obj instanceof Object[]) {
                dir = this.getDirection((Object[])obj);
            } else if (obj instanceof String) {
                dir = ForgeDirection.valueOf((String)((String)obj));
            }
            if (dir == null || dir == ForgeDirection.UNKNOWN) continue;
            return dir;
        }
        return ForgeDirection.UNKNOWN;
    }

    private Object[] callMethodForPeripheral(TileEntityPeripheral peripheral, ItemStack journal) throws MethodException {
        if (this.requiresJournal()) {
            if (journal == null || journal.func_77973_b() == null) {
                throw new MethodException(this, "Journal is missing");
            }
            ItemStack specimen = peripheral.getSpecimen();
            ItemStack seed = specimen.func_77946_l();
            if (specimen.func_77973_b() instanceof ITrowel) {
                seed = ((ITrowel)specimen.func_77973_b()).getSeed(specimen);
            }
            if (!this.isSeedDiscovered(journal, seed)) {
                throw new MethodException(this, "No information about this seed in the journal");
            }
        }
        return this.onMethodCalled(peripheral);
    }

    private Object[] callMethodForCrop(TileEntityCrop crop, ItemStack journal) throws MethodException {
        boolean hasJournal;
        boolean bl = hasJournal = journal != null;
        if (this.requiresJournal()) {
            if (!hasJournal) {
                throw new MethodException(this, "Journal is missing");
            }
            if (!this.isSeedDiscovered(journal, crop.getSeedStack())) {
                throw new MethodException(this, "No information about this seed in the journal");
            }
        }
        return this.onMethodCalled(crop);
    }

    protected abstract boolean appliesToCrop();

    protected abstract Object[] onMethodCalled(TileEntityCrop var1) throws MethodException;

    protected abstract boolean appliesToPeripheral();

    protected abstract Object[] onMethodCalled(TileEntityPeripheral var1) throws MethodException;

    protected abstract boolean requiresJournal();

    protected boolean isSeedDiscovered(ItemStack journal, ItemStack seed) {
        if (journal == null || journal.func_77973_b() == null || !(journal.func_77973_b() instanceof ItemJournal)) {
            return false;
        }
        return ((ItemJournal)journal.func_77973_b()).isSeedDiscovered(journal, seed);
    }

    protected CropPlant getCropPlant(ItemStack specimen) {
        ItemStack seed = specimen;
        if (specimen == null || specimen.func_77973_b() == null) {
            return null;
        }
        if (specimen.func_77973_b() instanceof ITrowel) {
            seed = ((ITrowel)specimen.func_77973_b()).getSeed(specimen);
        }
        return CropPlantHandler.getPlantFromStack(seed);
    }

    protected CropPlant getCropPlant(TileEntityCrop crop) {
        return crop.getPlant();
    }

    @Override
    public final String getDescription() {
        return StatCollector.func_74838_a((String)("agricraft_description.method." + this.getName()));
    }

    @Override
    public final String signature() {
        StringBuilder signature = new StringBuilder(this.getName() + "(");
        boolean separator = false;
        for (MethodParameter parameter : this.getParameters()) {
            if (separator) {
                signature.append(", ");
            } else {
                separator = true;
            }
            signature.append(parameter.getName());
        }
        signature.append(")");
        return signature.toString();
    }

    protected abstract ArrayList<MethodParameter> getParameters();
}

