/*
 * Decompiled with CFR 0.152.
 */
package neresources.compatibility.mobproperties;

import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import java.util.List;
import neresources.api.messages.ModifyMobMessage;
import neresources.api.utils.DropItem;
import neresources.api.utils.conditionals.Conditional;
import neresources.compatibility.CompatBase;
import neresources.compatibility.mobproperties.StringParser;
import neresources.registry.MessageRegistry;
import neresources.utils.LoaderHelper;
import neresources.utils.LogHelper;
import neresources.utils.ModList;
import neresources.utils.ReflectionHelper;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import toast.mobProperties.api.DropEntry;
import toast.mobProperties.api.MobPropertiesAPI;

public class MobPropertiesCompat
extends CompatBase {
    @Override
    protected void init() {
        if (LoaderHelper.isModVersionGreater(ModList.mobproperties.toString(), new int[]{0, 3, 5}, ".")) {
            this.loadAPIdata();
        } else {
            LogHelper.info(ModList.mobproperties.toString() + " is out of date");
        }
    }

    @Optional.Method(modid="MobProperties")
    private void loadAPIdata() {
        for (Object entity : EntityList.field_75626_c.keySet()) {
            List drops = MobPropertiesAPI.getDrops((Class)((Class)entity));
            if (drops.size() <= 0) continue;
            for (DropEntry drop : drops) {
                Item item = drop.getItem();
                ArrayList<DropItem> dropItems = new ArrayList<DropItem>();
                double[] amounts = (double[])ReflectionHelper.getObject(DropEntry.class, "attempts", drop);
                if (amounts == null || amounts.length < 2) {
                    amounts = new double[]{0.0, 1.0};
                }
                amounts[0] = amounts[0] * drop.getCounts()[0];
                amounts[1] = amounts[1] * drop.getCounts()[1];
                float chance = (float)(drop.getChance() / 2.0 * (amounts[0] + amounts[1]));
                int min = (int)Math.floor(amounts[0]);
                int max = (int)Math.ceil(amounts[1]);
                for (int i = (int)drop.getDamages()[0]; i <= (int)drop.getDamages()[1]; ++i) {
                    dropItems.add(new DropItem(new ItemStack(item, 1, i), min, max, chance, new Conditional[0]));
                }
                ModifyMobMessage message = new ModifyMobMessage((Class)entity, true, dropItems.toArray(new DropItem[dropItems.size()]));
                message = StringParser.addConditionals(message, drop.getConditions());
                MessageRegistry.addMessage(message);
            }
        }
    }
}

