/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.sa;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.instrument.Instrumentation;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.creeperhost.sa.Config;
import net.creeperhost.sa.Logger;
import net.creeperhost.sa.SerializationAgentTransformer;
import net.creeperhost.sa.repack.com.google.gson.Gson;
import net.creeperhost.sa.repack.com.google.gson.JsonParseException;
import org.jetbrains.annotations.Nullable;

public class SerializationAgent {
    private static final Gson GSON = new Gson();
    public static boolean DEBUG = false;
    public static boolean OFFLINE = false;
    @Nullable
    public static Config CONFIG;
    public static final Set<String> toTransform;
    public static final Set<String> allowedClasses;
    public static final List<String> allowedPackages;

    public static void premain(@Nullable String agentArgs, Instrumentation inst) {
        if (agentArgs != null) {
            for (String arg : agentArgs.split(",")) {
                if (arg.equals("debug")) {
                    DEBUG = true;
                    continue;
                }
                if (!arg.equals("offline")) continue;
                OFFLINE = true;
            }
        }
        if ((CONFIG = SerializationAgent.loadConfig()) == null) {
            Logger.info("Did not load a config. No patches will be applied.");
            return;
        }
        allowedClasses.addAll(SerializationAgent.CONFIG.classAllowlist);
        allowedPackages.addAll(SerializationAgent.CONFIG.packageAllowlist);
        for (Config.PatchModule patchModule : SerializationAgent.CONFIG.patchModules) {
            toTransform.addAll(patchModule.classesToPatch);
            allowedClasses.addAll(patchModule.classAllowlist);
            allowedPackages.addAll(patchModule.packageAllowlist);
        }
        Logger.debug("Identified " + toTransform.size() + " classes to try and transform.");
        Logger.debug("Identified " + allowedClasses.size() + " allowed classes.");
        Logger.debug("Identified " + allowedPackages.size() + " allowed package filters.");
        inst.addTransformer(new SerializationAgentTransformer());
    }

    @Nullable
    private static Config loadConfig() {
        Config config = null;
        try {
            config = SerializationAgent.loadLocalConfig();
        }
        catch (IOException ex) {
            Logger.error("Failed to load local config.", ex);
        }
        if (config == null && !OFFLINE) {
            try {
                config = SerializationAgent.loadRemoteConfig();
            }
            catch (IOException ex) {
                Logger.error("Failed to load remote config.", ex);
            }
        }
        if (config == null) {
            try {
                config = SerializationAgent.loadBuiltinConfig();
            }
            catch (IOException ex) {
                Logger.error("Failed to load local config.", ex);
            }
        }
        return config;
    }

    @Nullable
    private static Config loadLocalConfig() throws IOException {
        Path local = Paths.get("serializationisbad.json", new String[0]);
        Logger.debug("Trying to load local config from " + local.toAbsolutePath());
        if (Files.notExists(local, new LinkOption[0])) {
            Logger.debug(" Does not exist.");
            return null;
        }
        try (InputStream is = Files.newInputStream(local, new OpenOption[0]);){
            Config config = SerializationAgent.loadConfig(is);
            return config;
        }
    }

    private static Config loadBuiltinConfig() throws IOException {
        Logger.debug("Trying to load baked-in config.");
        try (InputStream is = SerializationAgent.class.getResourceAsStream("serializationisbad.json");){
            Config config = SerializationAgent.loadConfig(is);
            return config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Config loadRemoteConfig() throws IOException {
        Logger.debug("Trying to retrieve remote config...");
        URL url = new URL("https://raw.githubusercontent.com/dogboy21/serializationisbad/master/serializationisbad.json");
        HttpURLConnection connection = null;
        try {
            Config config;
            Throwable throwable;
            InputStream is;
            block20: {
                block21: {
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setConnectTimeout(5000);
                    connection.setReadTimeout(5000);
                    is = connection.getInputStream();
                    throwable = null;
                    config = SerializationAgent.loadConfig(is);
                    if (is == null) break block20;
                    if (throwable == null) break block21;
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block20;
                }
                is.close();
            }
            return config;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (is != null) {
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                is.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException ex) {
                    Logger.error("Failed to request remote config.", ex);
                    throwable = null;
                    if (connection != null) {
                        connection.disconnect();
                    }
                    return throwable;
                }
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static Config loadConfig(InputStream is) throws IOException {
        try {
            return GSON.fromJson((Reader)new InputStreamReader(is, StandardCharsets.UTF_8), Config.class);
        }
        catch (JsonParseException ex) {
            throw new IOException("Failed to parse json.", ex);
        }
    }

    static {
        toTransform = new HashSet<String>();
        allowedClasses = new HashSet<String>();
        allowedPackages = new ArrayList<String>();
    }
}

