/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.crossmod.vanilla;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import shedar.mods.ic2.nuclearcontrol.api.CardState;
import shedar.mods.ic2.nuclearcontrol.api.ICardWrapper;
import shedar.mods.ic2.nuclearcontrol.api.PanelSetting;
import shedar.mods.ic2.nuclearcontrol.api.PanelString;
import shedar.mods.ic2.nuclearcontrol.items.ItemCardBase;
import shedar.mods.ic2.nuclearcontrol.utils.LangHelper;
import shedar.mods.ic2.nuclearcontrol.utils.StringUtils;

public class ItemVanillaMachineCard
extends ItemCardBase {
    public static final int DISPLAY_BREWING = 1;
    public static final int DISPLAY_TIME = 2;
    public static final int DISPLAY_SLOT_1 = 4;
    public static final int DISPLAY_SLOT_2 = 8;
    public static final int DISPLAY_SLOT_3 = 16;
    private static final String BREW_STAND = "brewStand";
    private static final String FURNACE = "furnace";

    public ItemVanillaMachineCard() {
        super("cardVanilla");
    }

    @Override
    public CardState update(TileEntity panel, ICardWrapper card, int range) {
        return this.update(panel.func_145831_w(), card, range);
    }

    @Override
    public CardState update(World world, ICardWrapper card, int range) {
        ChunkCoordinates target = card.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity tile = world.func_147438_o(target.field_71574_a, target.field_71572_b, target.field_71573_c);
        if (tile instanceof TileEntityBrewingStand) {
            TileEntityBrewingStand brewingStand = (TileEntityBrewingStand)tile;
            card.setString("entity", BREW_STAND);
            card.setBoolean("brewing", brewingStand.func_145935_i() > 0);
            card.setInt("brewTime", brewingStand.func_145935_i());
            NBTTagCompound tag = new NBTTagCompound();
            if (brewingStand.func_145935_i() > 0) {
                if (brewingStand.func_70301_a(3) != null && brewingStand.func_70301_a(0) != null) {
                    tag.func_74778_a("Slot1", this.potionFN(brewingStand.func_70301_a(3), brewingStand.func_70301_a(0)));
                }
                if (brewingStand.func_70301_a(3) != null && brewingStand.func_70301_a(1) != null) {
                    tag.func_74778_a("Slot2", this.potionFN(brewingStand.func_70301_a(3), brewingStand.func_70301_a(1)));
                }
                if (brewingStand.func_70301_a(3) != null && brewingStand.func_70301_a(2) != null) {
                    tag.func_74778_a("Slot3", this.potionFN(brewingStand.func_70301_a(3), brewingStand.func_70301_a(2)));
                }
            }
            card.setTag("BrewInfo", tag);
            return CardState.OK;
        }
        if (tile instanceof TileEntityFurnace) {
            TileEntityFurnace furnace = (TileEntityFurnace)tile;
            card.setString("entity", FURNACE);
            card.setBoolean("burning", furnace.func_145950_i());
            card.setInt("burnTime", furnace.field_145956_a);
            NBTTagCompound tag = new NBTTagCompound();
            if (furnace.func_70301_a(0) != null) {
                tag.func_74778_a("Cooking", furnace.func_70301_a(0).func_82833_r());
                tag.func_74768_a("Csize", furnace.func_70301_a((int)0).field_77994_a);
            }
            if (furnace.func_70301_a(1) != null) {
                tag.func_74778_a("Fuel", furnace.func_70301_a(1).func_82833_r());
                tag.func_74768_a("Fsize", furnace.func_70301_a((int)1).field_77994_a);
            }
            if (furnace.func_70301_a(2) != null) {
                tag.func_74778_a("Output", furnace.func_70301_a(2).func_82833_r());
                tag.func_74768_a("Osize", furnace.func_70301_a((int)2).field_77994_a);
            }
            card.setTag("Info", tag);
            return CardState.OK;
        }
        return CardState.INVALID_CARD;
    }

    private String potionFN(ItemStack stack, ItemStack stack1) {
        int k = this.getSecondPotionList(stack1.func_77960_j(), stack);
        List list1 = Items.field_151068_bn.func_77834_f(k);
        if (list1 != null) {
            return StatCollector.func_74838_a((String)((PotionEffect)list1.get(0)).func_76453_d());
        }
        if (stack.func_77973_b().equals(Items.field_151137_ax)) {
            return StatCollector.func_74838_a((String)"potion.prefix.mundane");
        }
        if (stack.func_77973_b().equals(Items.field_151114_aO)) {
            return StatCollector.func_74838_a((String)"potion.prefix.thick");
        }
        return StatCollector.func_74838_a((String)"potion.prefix.awkward");
    }

    private int getSecondPotionList(int itemDamage, ItemStack stack) {
        return stack == null ? itemDamage : (stack.func_77973_b().func_150892_m(stack) ? PotionHelper.func_77913_a((int)itemDamage, (String)stack.func_77973_b().func_150896_i(stack)) : itemDamage);
    }

    @Override
    public UUID getCardType() {
        return new UUID(0L, 2L);
    }

    @Override
    public List<PanelString> getStringData(int displaySettings, ICardWrapper card, boolean showLabels) {
        LinkedList<PanelString> result = new LinkedList<PanelString>();
        if (card.getString("entity").equals(BREW_STAND)) {
            PanelString line;
            Boolean isBrewing = card.getBoolean("brewing");
            int brewTime = card.getInt("brewTime");
            NBTTagCompound tag = card.getTag("BrewInfo");
            if ((displaySettings & 2) > 0) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormatted("msg.nc.Vanilla.brewstand", brewTime, showLabels);
                result.add(line);
            }
            if ((displaySettings & 4) > 0) {
                String slot1pre = StatCollector.func_74838_a((String)"msg.nc.None");
                if (tag.func_74764_b("Slot1")) {
                    slot1pre = tag.func_74779_i("Slot1");
                }
                line = new PanelString();
                line.textLeft = StringUtils.getFormatted("msg.nc.Vanilla.potionType1", slot1pre, showLabels);
                result.add(line);
            }
            if ((displaySettings & 8) > 0) {
                String slot2pre = StatCollector.func_74838_a((String)"msg.nc.None");
                if (tag.func_74764_b("Slot2")) {
                    slot2pre = tag.func_74779_i("Slot2");
                }
                line = new PanelString();
                line.textLeft = StringUtils.getFormatted("msg.nc.Vanilla.potionType2", slot2pre, showLabels);
                result.add(line);
            }
            if ((displaySettings & 0x10) > 0) {
                String slot3pre = StatCollector.func_74838_a((String)"msg.nc.None");
                if (tag.func_74764_b("Slot3")) {
                    slot3pre = tag.func_74779_i("Slot3");
                }
                line = new PanelString();
                line.textLeft = StringUtils.getFormatted("msg.nc.Vanilla.potionType3", slot3pre, showLabels);
                result.add(line);
            }
            if ((displaySettings & 1) > 0) {
                String text;
                int txtColour = 0;
                if (isBrewing.booleanValue()) {
                    txtColour = 65280;
                    text = LangHelper.translate("msg.nc.Vanilla.brewing");
                } else {
                    txtColour = 0xFF0000;
                    text = LangHelper.translate("msg.nc.Vanilla.notBrewing");
                }
                if (result.size() > 0) {
                    PanelString firstLine = (PanelString)result.get(0);
                    firstLine.textRight = text;
                    firstLine.colorRight = txtColour;
                } else {
                    line = new PanelString();
                    line.textLeft = text;
                    line.colorLeft = txtColour;
                    result.add(line);
                }
            }
            return result;
        }
        if (card.getString("entity").equals(FURNACE)) {
            PanelString line;
            boolean isBurning = card.getBoolean("burning");
            int burnTime = card.getInt("burnTime");
            NBTTagCompound tagCompound = card.getTag("Info");
            if ((displaySettings & 2) > 0) {
                line = new PanelString();
                line.textLeft = StringUtils.getFormatted("msg.nc.Vanilla.burnTime", burnTime, showLabels);
                result.add(line);
            }
            if ((displaySettings & 4) > 0) {
                String slot1pre = StatCollector.func_74838_a((String)"msg.nc.None");
                if (tagCompound.func_74764_b("Cooking")) {
                    slot1pre = tagCompound.func_74779_i("Cooking");
                }
                line = new PanelString();
                line.textLeft = String.format(StatCollector.func_74838_a((String)"msg.nc.Vanilla.cooking"), tagCompound.func_74762_e("Csize"), slot1pre);
                result.add(line);
            }
            if ((displaySettings & 8) > 0) {
                String slot2pre = StatCollector.func_74838_a((String)"msg.nc.None");
                if (tagCompound.func_74764_b("Fuel")) {
                    slot2pre = tagCompound.func_74779_i("Fuel");
                }
                line = new PanelString();
                line.textLeft = String.format(StatCollector.func_74838_a((String)"msg.nc.Vanilla.fuel"), tagCompound.func_74762_e("Fsize"), slot2pre);
                result.add(line);
            }
            if ((displaySettings & 0x10) > 0) {
                String slot3pre = StatCollector.func_74838_a((String)"msg.nc.None");
                if (tagCompound.func_74764_b("Output")) {
                    slot3pre = tagCompound.func_74779_i("Output");
                }
                line = new PanelString();
                line.textLeft = String.format(StatCollector.func_74838_a((String)"msg.nc.Vanilla.output"), tagCompound.func_74762_e("Osize"), slot3pre);
                result.add(line);
            }
            if ((displaySettings & 1) > 0) {
                String text;
                int txtColour = 0;
                if (isBurning) {
                    txtColour = 65280;
                    text = LangHelper.translate("msg.nc.InfoPanelOn");
                } else {
                    txtColour = 0xFF0000;
                    text = LangHelper.translate("msg.nc.InfoPanelOff");
                }
                if (result.size() > 0) {
                    PanelString firstLine = (PanelString)result.get(0);
                    firstLine.textRight = text;
                    firstLine.colorRight = txtColour;
                } else {
                    line = new PanelString();
                    line.textLeft = text;
                    line.colorLeft = txtColour;
                    result.add(line);
                }
            }
        }
        return result;
    }

    @Override
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>();
        result.add(new PanelSetting(LangHelper.translate("msg.nc.Vanilla.dispBrew"), 1, this.getCardType()));
        result.add(new PanelSetting(LangHelper.translate("msg.nc.Vanilla.dispBrewTime"), 2, this.getCardType()));
        result.add(new PanelSetting(StringUtils.getFormattedKey("msg.nc.Vanilla.dispBrewUse", 1), 4, this.getCardType()));
        result.add(new PanelSetting(StringUtils.getFormattedKey("msg.nc.Vanilla.dispBrewUse", 2), 8, this.getCardType()));
        result.add(new PanelSetting(StringUtils.getFormattedKey("msg.nc.Vanilla.dispBrewUse", 3), 16, this.getCardType()));
        return result;
    }
}

