/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util;

import net.minecraft.block.Block;

public final class BlockWrapper {
    public Block block;
    public int metadata;

    public BlockWrapper(Block block, int metadata) {
        this.block = block;
        this.metadata = metadata;
    }

    public BlockWrapper set(Block block, int metadata) {
        if (block != null) {
            this.block = block;
            this.metadata = metadata;
        } else {
            this.block = null;
            this.metadata = 0;
        }
        return this;
    }

    public boolean isEqual(BlockWrapper other) {
        if (other == null) {
            return false;
        }
        if (this.metadata == other.metadata) {
            if (this.block == other.block) {
                return true;
            }
            if (this.block != null && other.block != null) {
                return this.block.delegate.get() == other.block.delegate.get();
            }
        }
        return false;
    }

    protected final int getId() {
        return Block.func_149682_b((Block)this.block);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BlockWrapper)) {
            return false;
        }
        return this.isEqual((BlockWrapper)o);
    }

    public int hashCode() {
        return this.metadata | this.getId() << 16;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.getClass().getName());
        b.append('@').append(System.identityHashCode(this)).append('{');
        b.append("m:").append(this.metadata).append(", i:").append(this.block == null ? null : this.block.getClass().getName());
        b.append('@').append(System.identityHashCode(this.block)).append(", v:");
        b.append(this.getId()).append('}');
        return b.toString();
    }
}

