/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world;

import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenMinableCluster;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenSparseMinableCluster
extends WorldGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final int genClusterSize;
    private final WeightedRandomBlock[] genBlock;

    public WorldGenSparseMinableCluster(ItemStack ore, int clusterSize) {
        this(new WeightedRandomBlock(ore), clusterSize);
    }

    public WorldGenSparseMinableCluster(WeightedRandomBlock resource, int clusterSize) {
        this(WorldGenMinableCluster.fabricateList(resource), clusterSize);
    }

    public WorldGenSparseMinableCluster(List<WeightedRandomBlock> resource, int clusterSize) {
        this(resource, clusterSize, Blocks.field_150348_b);
    }

    public WorldGenSparseMinableCluster(ItemStack ore, int clusterSize, Block block) {
        this(new WeightedRandomBlock(ore, 1), clusterSize, block);
    }

    public WorldGenSparseMinableCluster(WeightedRandomBlock resource, int clusterSize, Block block) {
        this(WorldGenMinableCluster.fabricateList(resource), clusterSize, block);
    }

    public WorldGenSparseMinableCluster(List<WeightedRandomBlock> resource, int clusterSize, Block block) {
        this(resource, clusterSize, WorldGenMinableCluster.fabricateList(block));
    }

    public WorldGenSparseMinableCluster(List<WeightedRandomBlock> resource, int clusterSize, List<WeightedRandomBlock> block) {
        this.cluster = resource;
        this.genClusterSize = clusterSize > 32 ? 32 : clusterSize;
        this.genBlock = block.toArray(new WeightedRandomBlock[block.size()]);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int blocks = this.genClusterSize;
        float f = rand.nextFloat() * (float)Math.PI;
        float yMin = y + rand.nextInt(3) - 2;
        float yMax = y + rand.nextInt(3) - 2;
        if (blocks == 1 && yMin > yMax) {
            ++blocks;
        }
        if (blocks == 2 && f > 1.5707964f) {
            ++blocks;
        }
        float xMin = (float)(x + 8) + MathHelper.func_76126_a((float)f) * (float)blocks / 8.0f;
        float xMax = (float)(x + 8) - MathHelper.func_76126_a((float)f) * (float)blocks / 8.0f;
        float zMin = (float)(z + 8) + MathHelper.func_76134_b((float)f) * (float)blocks / 8.0f;
        float zMax = (float)(z + 8) - MathHelper.func_76134_b((float)f) * (float)blocks / 8.0f;
        xMax -= xMin;
        yMax -= yMin;
        zMax -= zMin;
        boolean r = false;
        for (int i = 0; i <= blocks; ++i) {
            float xCenter = xMin + xMax * (float)i / (float)blocks;
            float yCenter = yMin + yMax * (float)i / (float)blocks;
            float zCenter = zMin + zMax * (float)i / (float)blocks;
            float size = (float)rand.nextDouble() * (float)blocks / 16.0f;
            float hMod = ((MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)blocks)) + 1.0f) * size + 1.0f) * 0.5f;
            float vMod = ((MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)blocks)) + 1.0f) * size + 1.0f) * 0.5f;
            int xStart = MathHelper.func_76141_d((float)(xCenter - hMod));
            int yStart = MathHelper.func_76141_d((float)(yCenter - vMod));
            int zStart = MathHelper.func_76141_d((float)(zCenter - hMod));
            int xStop = MathHelper.func_76141_d((float)(xCenter + hMod));
            int yStop = MathHelper.func_76141_d((float)(yCenter + vMod));
            int zStop = MathHelper.func_76141_d((float)(zCenter + hMod));
            for (int blockX = xStart; blockX <= xStop; ++blockX) {
                float xDistSq = ((float)blockX + 0.5f - xCenter) / hMod;
                if ((xDistSq *= xDistSq) >= 1.0f) continue;
                for (int blockY = yStart; blockY <= yStop; ++blockY) {
                    float xyDistSq;
                    float yDistSq = ((float)blockY + 0.5f - yCenter) / vMod;
                    if ((xyDistSq = (yDistSq *= yDistSq) + xDistSq) >= 1.0f) continue;
                    for (int blockZ = zStart; blockZ <= zStop; ++blockZ) {
                        float zDistSq = ((float)blockZ + 0.5f - zCenter) / hMod;
                        if ((zDistSq *= zDistSq) + xyDistSq >= 1.0f) continue;
                        r |= WorldGenMinableCluster.generateBlock(world, blockX, blockY, blockZ, this.genBlock, this.cluster);
                    }
                }
            }
        }
        return r;
    }
}

