/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.block;

import buildcraft.core.lib.render.EntityDropParticleFX;
import buildcraft.core.lib.utils.ResourceUtils;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public class BlockBuildCraftFluid
extends BlockFluidClassic {
    protected float particleRed;
    protected float particleGreen;
    protected float particleBlue;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] theIcon;
    protected boolean flammable;
    protected boolean dense = false;
    protected int flammability = 0;
    private MapColor mapColor;

    public BlockBuildCraftFluid(Fluid fluid, Material material, MapColor iMapColor) {
        super(fluid, material);
        this.mapColor = iMapColor;
    }

    public IIcon func_149691_a(int side, int meta) {
        return side != 0 && side != 1 ? this.theIcon[1] : this.theIcon[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        String prefix = ResourceUtils.getObjectPrefix(Block.field_149771_c.func_148750_c((Object)this));
        prefix = prefix.substring(0, prefix.indexOf(":") + 1) + "fluids/";
        this.theIcon = new IIcon[]{iconRegister.func_94245_a(prefix + this.fluidName + "_still"), iconRegister.func_94245_a(prefix + this.fluidName + "_flow")};
    }

    public static boolean isFluidExplosive(World world, int x, int z) {
        return world.field_73011_w.field_76574_g == -1;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (this.flammable && BlockBuildCraftFluid.isFluidExplosive(world, x, z)) {
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
            world.func_72885_a(null, (double)x, (double)y, (double)z, 4.0f, true, true);
        } else {
            super.func_149674_a(world, x, y, z, rand);
        }
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
        for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
            Block block = world.func_147439_a(x + fd.offsetX, y + fd.offsetY, z + fd.offsetZ);
            if (block instanceof BlockBuildCraftFluid) {
                world.func_147464_a(x + fd.offsetX, y + fd.offsetY, z + fd.offsetZ, block, 2);
                continue;
            }
            world.func_147460_e(x + fd.offsetX, y + fd.offsetY, z + fd.offsetZ, block);
        }
        this.func_149723_a(world, x, y, z, explosion);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (!this.dense || entity == null) {
            return;
        }
        entity.field_70181_x = Math.min(0.0, entity.field_70181_x);
        if (entity.field_70181_x < -0.05) {
            entity.field_70181_x *= 0.05;
        }
        entity.field_70159_w = Math.max(-0.05, Math.min(0.05, entity.field_70159_w * 0.05));
        entity.field_70181_x -= 0.05;
        entity.field_70179_y = Math.max(-0.05, Math.min(0.05, entity.field_70179_y * 0.05));
    }

    public BlockBuildCraftFluid setDense(boolean dense) {
        this.dense = dense;
        return this;
    }

    public BlockBuildCraftFluid setFlammable(boolean flammable) {
        this.flammable = flammable;
        return this;
    }

    public BlockBuildCraftFluid setFlammability(int flammability) {
        this.flammability = flammability;
        return this;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.flammable ? 300 : 0;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.flammability;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.flammable;
    }

    public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
        return this.flammable && this.flammability == 0;
    }

    public BlockBuildCraftFluid setParticleColor(float particleRed, float particleGreen, float particleBlue) {
        this.particleRed = particleRed;
        this.particleGreen = particleGreen;
        this.particleBlue = particleBlue;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        super.func_149734_b(world, x, y, z, rand);
        if (rand.nextInt(10) == 0 && World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) && !world.func_147439_a(x, y - 2, z).func_149688_o().func_76230_c()) {
            double px = (float)x + rand.nextFloat();
            double py = (double)y - 1.05;
            double pz = (float)z + rand.nextFloat();
            EntityDropParticleFX fx = new EntityDropParticleFX(world, px, py, pz, this.particleRed, this.particleGreen, this.particleBlue);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, x, y, z);
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, x, y, z);
    }

    public MapColor func_149728_f(int meta) {
        return this.mapColor;
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }
}

