/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.transactor;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.utils.transactor.IInvSlot;
import logisticspipes.utils.transactor.InventoryIterator;
import logisticspipes.utils.transactor.Transactor;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class TransactorSimple
extends Transactor {
    protected IInventory inventory;

    public TransactorSimple(IInventory inventory) {
        this.inventory = inventory;
    }

    @Override
    public int inject(ItemStack stack, ForgeDirection orientation, boolean doAdd) {
        ArrayList<IInvSlot> filledSlots = new ArrayList<IInvSlot>(this.inventory.func_70302_i_());
        ArrayList<IInvSlot> emptySlots = new ArrayList<IInvSlot>(this.inventory.func_70302_i_());
        for (IInvSlot slot : InventoryIterator.getIterable(this.inventory, orientation)) {
            if (!slot.canPutStackInSlot(stack)) continue;
            if (slot.getStackInSlot() == null) {
                emptySlots.add(slot);
                continue;
            }
            filledSlots.add(slot);
        }
        int injected = 0;
        injected = this.tryPut(stack, filledSlots, injected, doAdd);
        injected = this.tryPut(stack, emptySlots, injected, doAdd);
        this.inventory.func_70296_d();
        return injected;
    }

    private int tryPut(ItemStack stack, List<IInvSlot> slots, int injected, boolean doAdd) {
        int realInjected = injected;
        if (realInjected >= stack.field_77994_a) {
            return realInjected;
        }
        for (IInvSlot slot : slots) {
            int used;
            ItemStack stackInSlot = slot.getStackInSlot();
            if (stackInSlot != null && !this.canStacksMerge(stackInSlot, stack) || (used = this.addToSlot(slot, stack, realInjected, doAdd)) <= 0 || (realInjected += used) < stack.field_77994_a) continue;
            return realInjected;
        }
        return realInjected;
    }

    protected int addToSlot(IInvSlot slot, ItemStack stack, int injected, boolean doAdd) {
        int available = stack.field_77994_a - injected;
        int max = Math.min(stack.func_77976_d(), this.inventory.func_70297_j_());
        ItemStack stackInSlot = slot.getStackInSlot();
        if (stackInSlot == null) {
            int wanted = Math.min(available, max);
            if (doAdd) {
                stackInSlot = stack.func_77946_l();
                stackInSlot.field_77994_a = wanted;
                slot.setStackInSlot(stackInSlot);
            }
            return wanted;
        }
        if (!this.canStacksMerge(stack, stackInSlot)) {
            return 0;
        }
        int wanted = max - stackInSlot.field_77994_a;
        if (wanted <= 0) {
            return 0;
        }
        if (wanted > available) {
            wanted = available;
        }
        if (doAdd) {
            stackInSlot.field_77994_a += wanted;
            slot.setStackInSlot(stackInSlot);
        }
        return wanted;
    }

    private boolean canStacksMerge(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (!stack1.func_77969_a(stack2)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }
}

