/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.genetics.IItemStackRepresentitive;
import binnie.core.resource.BinnieIcon;
import binnie.extrabees.genetics.ExtraBeeMutation;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.core.ForestryEvent;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public abstract class BreedingSystem
implements IItemStackRepresentitive {
    protected BinnieIcon iconUndiscovered;
    protected BinnieIcon iconDiscovered;
    private List<IClassification> allBranches = new ArrayList<IClassification>();
    List<IAlleleSpecies> allActiveSpecies = new ArrayList<IAlleleSpecies>();
    private List<IAlleleSpecies> allSpecies = new ArrayList<IAlleleSpecies>();
    private List<IMutation> allMutations = new ArrayList<IMutation>();
    private Map<IAlleleSpecies, List<IMutation>> resultantMutations = new HashMap<IAlleleSpecies, List<IMutation>>();
    private Map<IAlleleSpecies, List<IMutation>> furtherMutations = new HashMap<IAlleleSpecies, List<IMutation>>();
    private Map<IAlleleSpecies, List<IMutation>> allResultantMutations = new HashMap<IAlleleSpecies, List<IMutation>>();
    private Map<IAlleleSpecies, List<IMutation>> allFurtherMutations = new HashMap<IAlleleSpecies, List<IMutation>>();
    public float discoveredSpeciesPercentage;
    public int totalSpeciesCount;
    public int discoveredSpeciesCount;
    public int totalSecretCount;
    public int discoveredSecretCount;
    public float discoveredBranchPercentage;
    public int totalBranchCount;
    public int discoveredBranchCount;
    private int totalSecretBranchCount;
    private int discoveredSecretBranchCount;
    String currentEpithet;

    public BreedingSystem() {
        Binnie.Genetics.registerBreedingSystem(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public String getChromosomeName(IChromosomeType chromo) {
        return BinnieCore.proxy.localise(this.getSpeciesRoot().getUID() + ".chromosome." + chromo.getName());
    }

    public String getChromosomeShortName(IChromosomeType chromo) {
        return BinnieCore.proxy.localise(this.getSpeciesRoot().getUID() + ".chromosome." + chromo.getName() + ".short");
    }

    public final String getEpitome(float discoveredPercentage) {
        int i = 0;
        if (discoveredPercentage == 1.0f) {
            i = 6;
        } else if (discoveredPercentage < 0.1f) {
            i = 0;
        } else if (discoveredPercentage < 0.3f) {
            i = 1;
        } else if (discoveredPercentage < 0.5f) {
            i = 2;
        } else if (discoveredPercentage < 0.7f) {
            i = 3;
        } else if (discoveredPercentage < 0.9f) {
            i = 4;
        } else if (discoveredPercentage < 1.0f) {
            i = 5;
        }
        return BinnieCore.proxy.localise(this.getSpeciesRoot().getUID() + ".epitome." + i);
    }

    public abstract ISpeciesRoot getSpeciesRoot();

    public final List<IClassification> getAllBranches() {
        return this.allBranches;
    }

    public final Collection<IAlleleSpecies> getAllSpecies() {
        return this.allActiveSpecies;
    }

    public final Collection<IMutation> getAllMutations() {
        return this.allMutations;
    }

    public void calculateArrays() {
        Collection allAlleles = AlleleManager.alleleRegistry.getRegisteredAlleles().values();
        this.resultantMutations = new HashMap<IAlleleSpecies, List<IMutation>>();
        this.furtherMutations = new HashMap<IAlleleSpecies, List<IMutation>>();
        this.allResultantMutations = new HashMap<IAlleleSpecies, List<IMutation>>();
        this.allFurtherMutations = new HashMap<IAlleleSpecies, List<IMutation>>();
        this.allActiveSpecies = new ArrayList<IAlleleSpecies>();
        this.allSpecies = new ArrayList<IAlleleSpecies>();
        for (IAllele species : allAlleles) {
            if (this.getSpeciesRoot().getTemplate(species.getUID()) == null) continue;
            this.resultantMutations.put((IAlleleSpecies)species, new ArrayList());
            this.furtherMutations.put((IAlleleSpecies)species, new ArrayList());
            this.allResultantMutations.put((IAlleleSpecies)species, new ArrayList());
            this.allFurtherMutations.put((IAlleleSpecies)species, new ArrayList());
            this.allSpecies.add((IAlleleSpecies)species);
            if (this.isBlacklisted(species) || species.getUID().contains("speciesBotAlfheim")) continue;
            this.allActiveSpecies.add((IAlleleSpecies)species);
        }
        this.allMutations = new ArrayList<IMutation>();
        Collection allRegBranches = AlleleManager.alleleRegistry.getRegisteredClassifications().values();
        this.allBranches = new ArrayList<IClassification>();
        for (IClassification branch : allRegBranches) {
            if (branch.getMemberSpecies().length <= 0 || this.getSpeciesRoot().getTemplate(branch.getMemberSpecies()[0].getUID()) == null) continue;
            boolean bl = false;
            for (IAlleleSpecies species : branch.getMemberSpecies()) {
                if (!this.allActiveSpecies.contains(species)) continue;
                bl = true;
            }
            if (!bl) continue;
            this.allBranches.add(branch);
        }
        if (this.getSpeciesRoot().getMutations(false) != null) {
            LinkedHashSet<IBeeMutation> mutations = new LinkedHashSet<IBeeMutation>();
            mutations.addAll(this.getSpeciesRoot().getMutations(false));
            if (this == Binnie.Genetics.beeBreedingSystem) {
                mutations.addAll(ExtraBeeMutation.mutations);
            }
            for (IMutation iMutation : mutations) {
                this.allMutations.add(iMutation);
                LinkedHashSet<IAlleleSpecies> participatingSpecies = new LinkedHashSet<IAlleleSpecies>();
                if (iMutation.getAllele0() instanceof IAlleleSpecies) {
                    participatingSpecies.add((IAlleleSpecies)iMutation.getAllele0());
                }
                if (iMutation.getAllele1() instanceof IAlleleSpecies) {
                    participatingSpecies.add((IAlleleSpecies)iMutation.getAllele1());
                }
                for (IAlleleSpecies species : participatingSpecies) {
                    this.allFurtherMutations.get(species).add(iMutation);
                    if (!this.allActiveSpecies.contains(species)) continue;
                    this.furtherMutations.get(species).add(iMutation);
                }
                if (!this.resultantMutations.containsKey(iMutation.getTemplate()[0])) continue;
                this.allResultantMutations.get(iMutation.getTemplate()[0]).add(iMutation);
                this.resultantMutations.get(iMutation.getTemplate()[0]).add(iMutation);
            }
        }
    }

    public final boolean isBlacklisted(IAllele allele) {
        return AlleleManager.alleleRegistry.isBlacklisted(allele.getUID());
    }

    public final List<IMutation> getResultantMutations(IAlleleSpecies species, boolean includeInactive) {
        if (this.resultantMutations.isEmpty()) {
            this.calculateArrays();
        }
        return includeInactive ? this.allResultantMutations.get(species) : this.resultantMutations.get(species);
    }

    public final List<IMutation> getResultantMutations(IAlleleSpecies species) {
        if (this.resultantMutations.isEmpty()) {
            this.calculateArrays();
        }
        return this.resultantMutations.get(species);
    }

    public final List<IMutation> getFurtherMutations(IAlleleSpecies species, boolean includeInactive) {
        if (this.furtherMutations.isEmpty()) {
            this.calculateArrays();
        }
        return includeInactive ? this.allFurtherMutations.get(species) : this.furtherMutations.get(species);
    }

    public final List<IMutation> getFurtherMutations(IAlleleSpecies species) {
        if (this.furtherMutations.isEmpty()) {
            this.calculateArrays();
        }
        return this.furtherMutations.get(species);
    }

    public final boolean isMutationDiscovered(IMutation mutation, World world, GameProfile name) {
        return this.isMutationDiscovered(mutation, this.getSpeciesRoot().getBreedingTracker(world, name));
    }

    public final boolean isMutationDiscovered(IMutation mutation, IBreedingTracker tracker) {
        if (tracker == null) {
            return true;
        }
        return tracker.isDiscovered(mutation);
    }

    public final boolean isSpeciesDiscovered(IAlleleSpecies species, World world, GameProfile name) {
        return this.isSpeciesDiscovered(species, this.getSpeciesRoot().getBreedingTracker(world, name));
    }

    public final boolean isSpeciesDiscovered(IAlleleSpecies species, IBreedingTracker tracker) {
        if (tracker == null) {
            return true;
        }
        return tracker.isDiscovered(species);
    }

    public final boolean isSecret(IAlleleSpecies species) {
        return !species.isCounted();
    }

    public final boolean isSecret(IClassification branch) {
        for (IAlleleSpecies species : branch.getMemberSpecies()) {
            if (this.isSecret(species)) continue;
            return false;
        }
        return true;
    }

    public final Collection<IClassification> getDiscoveredBranches(World world, GameProfile player) {
        ArrayList<IClassification> branches = new ArrayList<IClassification>();
        for (IClassification branch : this.getAllBranches()) {
            boolean discovered = false;
            for (IAlleleSpecies species : branch.getMemberSpecies()) {
                if (!this.isSpeciesDiscovered(species, world, player)) continue;
                discovered = true;
            }
            if (!discovered) continue;
            branches.add(branch);
        }
        return branches;
    }

    public final Collection<IClassification> getDiscoveredBranches(IBreedingTracker tracker) {
        ArrayList<IClassification> branches = new ArrayList<IClassification>();
        for (IClassification branch : this.getAllBranches()) {
            boolean discovered = false;
            for (IAlleleSpecies species : branch.getMemberSpecies()) {
                if (!this.isSpeciesDiscovered(species, tracker)) continue;
                discovered = true;
            }
            if (!discovered) continue;
            branches.add(branch);
        }
        return branches;
    }

    public final Collection<IAlleleSpecies> getDiscoveredSpecies(World world, GameProfile player) {
        ArrayList<IAlleleSpecies> speciesList = new ArrayList<IAlleleSpecies>();
        for (IAlleleSpecies species : this.getAllSpecies()) {
            if (!this.isSpeciesDiscovered(species, world, player)) continue;
            speciesList.add(species);
        }
        return speciesList;
    }

    public final Collection<IAlleleSpecies> getDiscoveredSpecies(IBreedingTracker tracker) {
        ArrayList<IAlleleSpecies> speciesList = new ArrayList<IAlleleSpecies>();
        for (IAlleleSpecies species : this.getAllSpecies()) {
            if (!this.isSpeciesDiscovered(species, tracker)) continue;
            speciesList.add(species);
        }
        return speciesList;
    }

    public final List<IMutation> getDiscoveredMutations(World world, GameProfile player) {
        ArrayList<IMutation> speciesList = new ArrayList<IMutation>();
        for (IMutation species : this.getAllMutations()) {
            if (!this.isMutationDiscovered(species, world, player)) continue;
            speciesList.add(species);
        }
        return speciesList;
    }

    public final List<IMutation> getDiscoveredMutations(IBreedingTracker tracker) {
        ArrayList<IMutation> speciesList = new ArrayList<IMutation>();
        for (IMutation species : this.getAllMutations()) {
            if (!this.isMutationDiscovered(species, tracker)) continue;
            speciesList.add(species);
        }
        return speciesList;
    }

    public final int getDiscoveredBranchMembers(IClassification branch, IBreedingTracker tracker) {
        int discoveredSpecies = 0;
        for (IAlleleSpecies species : branch.getMemberSpecies()) {
            if (!this.isSpeciesDiscovered(species, tracker)) continue;
            ++discoveredSpecies;
        }
        return discoveredSpecies;
    }

    public IIcon getUndiscoveredIcon() {
        return this.iconUndiscovered.getIcon();
    }

    public IIcon getDiscoveredIcon() {
        return this.iconDiscovered.getIcon();
    }

    public abstract float getChance(IMutation var1, EntityPlayer var2, IAllele var3, IAllele var4);

    public abstract Class<? extends IBreedingTracker> getTrackerClass();

    @SubscribeEvent
    public final void onSyncBreedingTracker(ForestryEvent.SyncedBreedingTracker event) {
        IBreedingTracker tracker = event.tracker;
        if (!this.getTrackerClass().isInstance(tracker)) {
            return;
        }
        this.syncTracker(tracker);
    }

    public final void syncTracker(IBreedingTracker tracker) {
        this.discoveredSpeciesPercentage = 0.0f;
        this.totalSpeciesCount = 0;
        this.discoveredSpeciesCount = 0;
        this.totalSecretCount = 0;
        this.discoveredSecretCount = 0;
        Collection<IAlleleSpecies> discoveredSpecies = this.getDiscoveredSpecies(tracker);
        Collection<IAlleleSpecies> allSpecies = this.getAllSpecies();
        for (IAlleleSpecies species : allSpecies) {
            if (!this.isSecret(species)) {
                ++this.totalSpeciesCount;
                if (!this.isSpeciesDiscovered(species, tracker)) continue;
                ++this.discoveredSpeciesCount;
                continue;
            }
            ++this.totalSecretCount;
            if (!this.isSpeciesDiscovered(species, tracker)) continue;
            ++this.discoveredSecretCount;
        }
        this.discoveredBranchPercentage = 0.0f;
        this.totalBranchCount = 0;
        this.discoveredBranchCount = 0;
        Collection<IClassification> discoveredBranches = this.getDiscoveredBranches(tracker);
        List<IClassification> allBranches = this.getAllBranches();
        for (IClassification branch : allBranches) {
            if (!this.isSecret(branch)) {
                ++this.totalBranchCount;
                if (!discoveredBranches.contains(branch)) continue;
                ++this.discoveredBranchCount;
                continue;
            }
            ++this.totalSecretBranchCount;
            if (!discoveredBranches.contains(branch)) continue;
            ++this.discoveredSecretBranchCount;
        }
        this.discoveredSpeciesPercentage = (float)this.discoveredSpeciesCount / (float)this.totalSpeciesCount;
        this.discoveredBranchPercentage = (float)this.discoveredBranchCount / (float)this.totalBranchCount;
        String epithet = this.getEpitome();
        this.onSyncBreedingTracker(tracker);
    }

    public void onSyncBreedingTracker(IBreedingTracker tracker) {
    }

    public String getEpitome() {
        return this.getEpitome(this.discoveredSpeciesPercentage);
    }

    public final String getDescriptor() {
        return BinnieCore.proxy.localise(this.getSpeciesRoot().getUID() + ".descriptor");
    }

    public final String getIdent() {
        return this.getSpeciesRoot().getUID();
    }

    public final IChromosomeType getChromosome(int i) {
        for (IChromosomeType chromosome : this.getSpeciesRoot().getKaryotype()) {
            if (i != chromosome.ordinal()) continue;
            return chromosome;
        }
        return null;
    }

    public abstract int getColour();

    public String getAlleleName(IChromosomeType chromosome, IAllele allele) {
        if (allele instanceof IAlleleBoolean) {
            return ((IAlleleBoolean)allele).getValue() ? Binnie.Language.localise(BinnieCore.instance, "allele.true") : Binnie.Language.localise(BinnieCore.instance, "allele.false");
        }
        if (allele.getName() == "for.gui.maximum") {
            return Binnie.Language.localise(BinnieCore.instance, "allele.fertility.maximum");
        }
        return allele.getName();
    }

    public String getName() {
        return BinnieCore.proxy.localise(this.getSpeciesRoot().getUID() + ".shortName");
    }

    @Override
    public ItemStack getItemStackRepresentitive() {
        IIndividual first = (IIndividual)this.getSpeciesRoot().getIndividualTemplates().get(0);
        return this.getSpeciesRoot().getMemberStack(first, this.getDefaultType());
    }

    public String toString() {
        return this.getName();
    }

    public abstract boolean isDNAManipulable(ItemStack var1);

    public IIndividual getConversion(ItemStack stack) {
        return null;
    }

    public final IIndividual getDefaultIndividual() {
        return this.getSpeciesRoot().templateAsIndividual(this.getSpeciesRoot().getDefaultTemplate());
    }

    public final int getDefaultType() {
        return this.getActiveTypes()[0];
    }

    public abstract int[] getActiveTypes();

    public abstract void addExtraAlleles(IChromosomeType var1, TreeSet<IAllele> var2);

    public ItemStack getConversionStack(ItemStack stack) {
        return this.getSpeciesRoot().getMemberStack(this.getConversion(stack), this.getDefaultType());
    }

    public final Collection<IChromosomeType> getActiveKaryotype() {
        return Binnie.Genetics.getActiveChromosomes(this.getSpeciesRoot());
    }

    public ItemStack getDefaultMember(String uid) {
        return this.getSpeciesRoot().getMemberStack(this.getIndividual(uid), this.getDefaultType());
    }

    public IIndividual getIndividual(String uid) {
        return this.getSpeciesRoot().templateAsIndividual(this.getSpeciesRoot().getTemplate(uid));
    }

    public IGenome getGenome(String uid) {
        return this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate(uid));
    }
}

