/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.liquid;

import binnie.Binnie;
import binnie.core.liquid.BinnieFluid;
import binnie.core.liquid.FluidContainer;
import binnie.core.liquid.IFluidType;
import binnie.extratrees.alcohol.AlcoholEffect;
import binnie.extratrees.alcohol.drink.DrinkManager;
import binnie.extratrees.alcohol.drink.IDrinkLiquid;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class ItemFluidContainer
extends ItemFood {
    private FluidContainer container;
    public static int LiquidExtraBee = 64;
    public static int LiquidExtraTree = 128;
    public static int LiquidJuice = 256;
    public static int LiquidAlcohol = 384;
    public static int LiquidSpirit = 512;
    public static int LiquidLiqueuer = 640;
    public static int LiquidGenetics = 768;
    private static Map<Integer, String> idToFluid = new HashMap<Integer, String>();
    private static Map<String, Integer> fluidToID = new HashMap<String, Integer>();

    public static void registerFluid(IFluidType fluid, int id) {
        idToFluid.put(id, fluid.getIdentifier().toLowerCase());
        fluidToID.put(fluid.getIdentifier().toLowerCase(), id);
    }

    public ItemFluidContainer(FluidContainer container) {
        super(0, false);
        this.container = container;
        container.item = this;
        this.field_77777_bU = container.getMaxStackSize();
        this.func_77627_a(true);
        this.func_77655_b("container" + container.name());
        this.func_77637_a(CreativeTabs.field_78035_l);
    }

    private FluidStack getLiquid(ItemStack stack) {
        String liquid = idToFluid.get(stack.func_77960_j());
        return liquid == null ? null : Binnie.Liquid.getLiquidStack(liquid, 1000);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.container.updateIcons(register);
    }

    public String func_77653_i(ItemStack itemstack) {
        if (itemstack == null) {
            return "???";
        }
        FluidStack fluid = this.getLiquid(itemstack);
        if (fluid == null) {
            return "Missing Fluid";
        }
        return fluid.getFluid().getLocalizedName(fluid) + " " + this.container.getName();
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List itemList) {
        for (IFluidType liquid : Binnie.Liquid.fluids.values()) {
            if (!liquid.canPlaceIn(this.container) || !liquid.showInCreative(this.container)) continue;
            itemList.add(this.getContainer(liquid));
        }
    }

    public ItemStack getContainer(IFluidType liquid) {
        int id = fluidToID.get(liquid.getIdentifier().toLowerCase());
        ItemStack itemstack = new ItemStack((Item)this, 1, id);
        return itemstack;
    }

    public IIcon getIcon(ItemStack itemstack, int j) {
        if (j > 0) {
            return this.container.getBottleIcon();
        }
        return this.container.getContentsIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack item, int pass) {
        FluidStack fluid = this.getLiquid(item);
        if (fluid == null) {
            return 0xFFFFFF;
        }
        if (pass == 0 && fluid.getFluid() instanceof BinnieFluid) {
            return ((BinnieFluid)fluid.getFluid()).fluidType.getContainerColour();
        }
        return super.func_82790_a(item, pass);
    }

    public boolean func_77623_v() {
        return true;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        player.func_71024_bL().func_151686_a((ItemFood)this, stack);
        world.func_72956_a((Entity)player, "random.burp", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        this.func_77849_c(stack, world, player);
        return this.container.getEmpty();
    }

    protected void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        FluidStack fluid;
        IDrinkLiquid liquid;
        if (!world.field_72995_K && (liquid = DrinkManager.getLiquid(fluid = this.getLiquid(stack))) != null) {
            AlcoholEffect.makeDrunk(player, liquid.getABV() * (float)fluid.amount);
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.isDrinkable(stack) ? EnumAction.drink : EnumAction.none;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (this.isDrinkable(stack)) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public int func_150905_g(ItemStack p_150905_1_) {
        return 0;
    }

    public float func_150906_h(ItemStack p_150906_1_) {
        return 0.0f;
    }

    private boolean isDrinkable(ItemStack stack) {
        FluidStack fluid = this.getLiquid(stack);
        IDrinkLiquid liquid = DrinkManager.getLiquid(fluid);
        return liquid == null ? false : liquid.isConsumable();
    }
}

