/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.extratrees.kitchen;

import binnie.craftgui.controls.core.Control;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.CraftGUI;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.Widget;
import binnie.craftgui.core.geometry.IPoint;
import binnie.craftgui.minecraft.Window;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class ControlFluidDisplay
extends Control
implements ITooltip {
    FluidStack itemStack = null;
    public boolean hastooltip = false;

    public void setTooltip() {
        this.hastooltip = true;
        this.addAttribute(Attribute.MouseOver);
    }

    public ControlFluidDisplay(IWidget parent, float f, float y) {
        this(parent, f, y, 16.0f);
    }

    public ControlFluidDisplay(IWidget parent, float f, float y, FluidStack stack, boolean tooltip) {
        this(parent, f, y, 16.0f);
        this.setItemStack(stack);
        if (tooltip) {
            this.setTooltip();
        }
    }

    public ControlFluidDisplay(IWidget parent, float x, float y, float size) {
        super(parent, x, y, size, size);
    }

    @Override
    public void onRenderForeground() {
        if (this.itemStack == null) {
            return;
        }
        IPoint relativeToWindow = this.getAbsolutePosition().sub(this.getSuperParent().getPosition());
        if (relativeToWindow.x() > ((Widget)Window.get(this)).getSize().x() + 100.0f || relativeToWindow.y() > ((Widget)Window.get(this)).getSize().y() + 100.0f) {
            return;
        }
        if (this.itemStack != null) {
            Fluid fluid = this.itemStack.getFluid();
            int hex = fluid.getColor(this.itemStack);
            int r = (hex & 0xFF0000) >> 16;
            int g = (hex & 0xFF00) >> 8;
            int b = hex & 0xFF;
            IIcon icon = this.itemStack.getFluid().getIcon(this.itemStack);
            GL11.glColor4f((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)1.0f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            if (this.getSize().x() != 16.0f) {
                GL11.glPushMatrix();
                float scale = this.getSize().x() / 16.0f;
                GL11.glScalef((float)scale, (float)scale, (float)1.0f);
                CraftGUI.Render.iconBlock(IPoint.ZERO, this.itemStack.getFluid().getIcon(this.itemStack));
                GL11.glPopMatrix();
            } else {
                CraftGUI.Render.iconBlock(IPoint.ZERO, this.itemStack.getFluid().getIcon(this.itemStack));
            }
            GL11.glDisable((int)3042);
        }
    }

    public void setItemStack(FluidStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        if (this.hastooltip && this.itemStack != null) {
            tooltip.add(this.itemStack.getLocalizedName());
        }
    }
}

