/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gen;

import binnie.extratrees.gen.WorldGenTree;
import binnie.extratrees.genetics.ExtraTreeSpecies;
import binnie.extratrees.worldgen.BlockType;
import binnie.extratrees.worldgen.BlockTypeLeaf;
import binnie.extratrees.worldgen.BlockTypeLog;
import forestry.api.arboriculture.ITree;

public class WorldGenDefault
extends WorldGenTree {
    public WorldGenDefault(ITree tree) {
        super(tree);
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        int leafSpawn = this.height + 1;
        this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), 1.0f, 1, this.leaf, false);
        this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), 1.5f, 1, this.leaf, false);
        this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), 2.9f, 1, this.leaf, false);
        this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), 2.9f, 1, this.leaf, false);
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(5, 2);
        this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
    }

    @Override
    public BlockType getLeaf() {
        return new BlockTypeLeaf();
    }

    @Override
    public BlockType getWood() {
        return new BlockTypeLog(((ExtraTreeSpecies)this.tree.getGenome().getPrimary()).getLog());
    }
}

