/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui;

import binnie.botany.api.EnumFlowerStage;
import binnie.botany.api.IAlleleFlowerSpecies;
import binnie.botany.api.IFlower;
import binnie.craftgui.botany.ControlColourDisplay;
import binnie.craftgui.controls.ControlTextCentered;
import binnie.craftgui.core.CraftGUI;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.IPoint;
import binnie.craftgui.minecraft.control.ControlIconDisplay;
import binnie.genetics.gui.ControlAnalystPage;
import org.lwjgl.opengl.GL11;

public class AnalystPageAppearance
extends ControlAnalystPage {
    public AnalystPageAppearance(IWidget parent, IArea area, final IFlower ind) {
        super(parent, area);
        this.setColour(0x333333);
        int y = 4;
        IAlleleFlowerSpecies species = ind.getGenome().getPrimary();
        new ControlTextCentered((IWidget)this, y, "\u00a7nAppearance").setColour(this.getColour());
        ControlColourDisplay a = new ControlColourDisplay(this, this.w() / 2.0f - 28.0f, y += 12);
        a.setValue(ind.getGenome().getPrimaryColor());
        a.addTooltip("Primary Petal Colour");
        ControlColourDisplay b = new ControlColourDisplay(this, this.w() / 2.0f - 8.0f, y);
        b.setValue(ind.getGenome().getSecondaryColor());
        b.addTooltip("Secondary Petal Colour");
        ControlColourDisplay c = new ControlColourDisplay(this, this.w() / 2.0f + 12.0f, y);
        c.setValue(ind.getGenome().getStemColor());
        c.addTooltip("Stem Colour");
        final int sections = ind.getGenome().getType().getSections();
        final int w = sections > 1 ? 50 : 100;
        new ControlIconDisplay(this, (this.w() - (float)w) / 2.0f, (y += 26) - (sections == 1 ? 0 : 0), null){

            @Override
            public void onRenderForeground() {
                GL11.glPushMatrix();
                float scale = (float)w / 16.0f;
                float dy = sections > 1 ? 16.0f : 0.0f;
                GL11.glScalef((float)scale, (float)scale, (float)1.0f);
                CraftGUI.Render.colour(ind.getGenome().getStemColor().getColor(false));
                if (sections > 1) {
                    CraftGUI.Render.iconBlock(new IPoint(0.0f, 0.0f), ind.getGenome().getType().getStem(EnumFlowerStage.FLOWER, true, 1));
                }
                CraftGUI.Render.iconBlock(new IPoint(0.0f, dy), ind.getGenome().getType().getStem(EnumFlowerStage.FLOWER, true, 0));
                CraftGUI.Render.colour(ind.getGenome().getPrimaryColor().getColor(false));
                if (sections > 1) {
                    CraftGUI.Render.iconBlock(new IPoint(0.0f, 0.0f), ind.getGenome().getType().getPetalIcon(EnumFlowerStage.FLOWER, true, 1));
                }
                CraftGUI.Render.iconBlock(new IPoint(0.0f, dy), ind.getGenome().getType().getPetalIcon(EnumFlowerStage.FLOWER, true, 0));
                CraftGUI.Render.colour(ind.getGenome().getSecondaryColor().getColor(false));
                if (sections > 1) {
                    CraftGUI.Render.iconBlock(new IPoint(0.0f, 0.0f), ind.getGenome().getType().getVariantIcon(EnumFlowerStage.FLOWER, true, 1));
                }
                CraftGUI.Render.iconBlock(new IPoint(0.0f, dy), ind.getGenome().getType().getVariantIcon(EnumFlowerStage.FLOWER, true, 0));
                GL11.glPopMatrix();
            }
        };
    }

    @Override
    public String getTitle() {
        return "Appearance";
    }
}

