/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui;

import binnie.core.util.UniqueFluidStackSet;
import binnie.core.util.UniqueItemStackSet;
import binnie.craftgui.controls.ControlTextCentered;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.minecraft.control.ControlItemDisplay;
import binnie.extratrees.machines.Brewery;
import binnie.extratrees.machines.Distillery;
import binnie.extratrees.machines.Press;
import binnie.genetics.gui.ControlAnalystPage;
import forestry.api.recipes.RecipeManagers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public abstract class AnalystPageProduce
extends ControlAnalystPage {
    public AnalystPageProduce(IWidget parent, IArea area) {
        super(parent, area);
    }

    protected Collection<? extends ItemStack> getAllProducts(ItemStack key) {
        UniqueItemStackSet products = new UniqueItemStackSet();
        products.addAll(this.getCentrifuge(key));
        products.addAll(this.getSqueezer(key));
        products.add(FurnaceRecipes.func_77602_a().func_151395_a(key));
        products.addAll(this.getCrafting(key));
        return products;
    }

    public Collection<ItemStack> getCentrifuge(ItemStack stack) {
        ArrayList<ItemStack> products = new ArrayList<ItemStack>();
        for (Map.Entry recipe : RecipeManagers.centrifugeManager.getRecipes().entrySet()) {
            boolean isRecipe = false;
            for (Object obj : (Object[])recipe.getKey()) {
                if (!(obj instanceof ItemStack) || !stack.func_77969_a((ItemStack)obj)) continue;
                isRecipe = true;
            }
            if (!isRecipe) continue;
            for (Object obj : (Object[])recipe.getValue()) {
                if (!(obj instanceof ItemStack)) continue;
                products.add((ItemStack)obj);
            }
        }
        return products;
    }

    public Collection<ItemStack> getSqueezer(ItemStack stack) {
        ArrayList<ItemStack> products = new ArrayList<ItemStack>();
        for (Map.Entry recipe : RecipeManagers.squeezerManager.getRecipes().entrySet()) {
            boolean isRecipe = false;
            for (Object obj : (Object[])recipe.getKey()) {
                if (!(obj instanceof ItemStack) || !stack.func_77969_a((ItemStack)obj)) continue;
                isRecipe = true;
            }
            if (!isRecipe) continue;
            for (Object obj : (Object[])recipe.getValue()) {
                if (!(obj instanceof ItemStack)) continue;
                products.add((ItemStack)obj);
            }
        }
        return products;
    }

    public Collection<ItemStack> getCrafting(ItemStack stack) {
        ArrayList<ItemStack> products = new ArrayList<ItemStack>();
        for (Object recipeO : CraftingManager.func_77594_a().func_77592_b()) {
            boolean match;
            ShapelessRecipes recipe;
            if (recipeO instanceof ShapelessRecipes) {
                recipe = (ShapelessRecipes)recipeO;
                match = true;
                for (Object rec : recipe.field_77579_b) {
                    if (rec == null || rec instanceof ItemStack && stack.func_77969_a((ItemStack)rec)) continue;
                    match = false;
                }
                if (match) {
                    products.add(recipe.func_77571_b());
                }
            }
            if (recipeO instanceof ShapedRecipes) {
                recipe = (ShapedRecipes)recipeO;
                match = true;
                for (ItemStack rec : recipe.field_77574_d) {
                    if (rec == null || rec instanceof ItemStack && stack.func_77969_a(rec)) continue;
                    match = false;
                }
                if (match) {
                    products.add(recipe.func_77571_b());
                }
            }
            if (!(recipeO instanceof ShapelessOreRecipe)) continue;
            recipe = (ShapelessOreRecipe)recipeO;
            match = true;
            for (Object rec : recipe.getInput()) {
                if (rec == null || rec instanceof ItemStack && stack.func_77969_a((ItemStack)rec)) continue;
                match = false;
            }
            if (!match) continue;
            products.add(recipe.func_77571_b());
        }
        return products;
    }

    public Collection<FluidStack> getAllFluids(ItemStack stack) {
        ArrayList<FluidStack> products = new ArrayList<FluidStack>();
        products.addAll(this.getSqueezerFluid(stack));
        if (Press.getOutput(stack) != null) {
            products.add(Press.getOutput(stack));
        }
        return products;
    }

    public Collection<FluidStack> getSqueezerFluid(ItemStack stack) {
        ArrayList<FluidStack> products = new ArrayList<FluidStack>();
        for (Map.Entry recipe : RecipeManagers.squeezerManager.getRecipes().entrySet()) {
            boolean isRecipe = false;
            for (Object obj : (Object[])recipe.getKey()) {
                if (!(obj instanceof ItemStack) || !stack.func_77969_a((ItemStack)obj)) continue;
                isRecipe = true;
            }
            if (!isRecipe) continue;
            for (Object obj : (Object[])recipe.getValue()) {
                if (!(obj instanceof FluidStack)) continue;
                products.add((FluidStack)obj);
            }
        }
        return products;
    }

    protected Collection<? extends FluidStack> getAllProducts(FluidStack stack) {
        UniqueFluidStackSet fluids = new UniqueFluidStackSet();
        fluids.add(Brewery.getOutput(stack));
        fluids.add(Distillery.getOutput(stack, 0));
        fluids.add(Distillery.getOutput(stack, 1));
        fluids.add(Distillery.getOutput(stack, 2));
        return fluids;
    }

    protected Collection<ItemStack> getAllProductsAndFluids(Collection<ItemStack> collection) {
        UniqueItemStackSet products = new UniqueItemStackSet();
        for (ItemStack stack : collection) {
            products.addAll(this.getAllProducts(stack));
        }
        UniqueItemStackSet products2 = new UniqueItemStackSet();
        for (ItemStack stack : products) {
            products2.addAll(this.getAllProducts(stack));
        }
        UniqueItemStackSet products3 = new UniqueItemStackSet();
        for (ItemStack stack : products2) {
            products3.addAll(this.getAllProducts(stack));
        }
        products.addAll(products2);
        products.addAll(products3);
        UniqueFluidStackSet allFluids = new UniqueFluidStackSet();
        for (ItemStack stack : collection) {
            allFluids.addAll(this.getAllFluids(stack));
        }
        UniqueFluidStackSet fluids2 = new UniqueFluidStackSet();
        for (FluidStack stack : allFluids) {
            fluids2.addAll(this.getAllProducts(stack));
        }
        UniqueFluidStackSet fluids3 = new UniqueFluidStackSet();
        for (FluidStack stack : fluids2) {
            fluids3.addAll(this.getAllProducts(stack));
        }
        allFluids.addAll(fluids2);
        allFluids.addAll(fluids3);
        for (FluidStack fluid : allFluids) {
            ItemStack container = null;
            for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                if (data.emptyContainer.func_77969_a(new ItemStack(Items.field_151069_bo)) && data.fluid.isFluidEqual(fluid)) {
                    container = data.filledContainer;
                    break;
                }
                if (data.emptyContainer.func_77969_a(new ItemStack(Items.field_151133_ar)) && data.fluid.isFluidEqual(fluid)) {
                    container = data.filledContainer;
                    break;
                }
                if (!data.fluid.isFluidEqual(fluid)) continue;
                container = data.filledContainer;
                break;
            }
            if (container == null) continue;
            products.add(container);
        }
        return products;
    }

    protected int getRefined(String string, int y, Collection<ItemStack> products) {
        new ControlTextCentered((IWidget)this, y, string).setColour(this.getColour());
        y += 10;
        int maxBiomePerLine = (int)((this.w() + 2.0f - 16.0f) / 18.0f);
        float biomeListX = (this.w() - (float)(Math.min(maxBiomePerLine, products.size()) * 18 - 2)) / 2.0f;
        int dx = 0;
        int dy = 0;
        for (ItemStack soilStack : products) {
            if (dx >= 18 * maxBiomePerLine) {
                dx = 0;
                dy += 18;
            }
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)soilStack);
            soilStack.field_77994_a = 1;
            ControlItemDisplay display = new ControlItemDisplay((IWidget)this, biomeListX + (float)dx, (float)(y + dy), soilStack, fluid == null);
            if (fluid != null) {
                display.addTooltip(fluid.getLocalizedName());
            }
            dx += 18;
        }
        if (dx != 0) {
            dy += 18;
        }
        return y += dy;
    }
}

