/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class Panel
extends AbstractContainerWidget<Panel> {
    private Layout layout = new HorizontalLayout();
    private Widget focus = null;

    public Panel(Minecraft mc, Gui gui) {
        super(mc, gui);
    }

    public Panel setLayout(Layout layout) {
        this.layout = layout;
        this.markDirty();
        return this;
    }

    @Override
    public void draw(Window window, int x, int y) {
        if (!this.visible) {
            return;
        }
        super.draw(window, x, y);
        int xx = x + this.bounds.x;
        int yy = y + this.bounds.y;
        if (this.isDirty()) {
            this.layout.doLayout(this.children, this.bounds.width, this.bounds.height);
            this.markClean();
        }
        for (Widget child : this.children) {
            child.draw(window, xx, yy);
        }
    }

    @Override
    public Widget mouseClick(Window window, int x, int y, int button) {
        super.mouseClick(window, x, y, button);
        x -= this.bounds.x;
        y -= this.bounds.y;
        for (Widget child : this.children) {
            if (!child.in(x, y) || !child.isVisible()) continue;
            this.focus = child.mouseClick(window, x, y, button);
            return this;
        }
        return null;
    }

    @Override
    public void mouseRelease(int x, int y, int button) {
        super.mouseRelease(x, y, button);
        x -= this.bounds.x;
        y -= this.bounds.y;
        if (this.focus != null) {
            this.focus.mouseRelease(x, y, button);
            this.focus = null;
        } else {
            for (Widget child : this.children) {
                if (!child.in(x, y) || !child.isVisible()) continue;
                child.mouseRelease(x, y, button);
                return;
            }
        }
    }

    @Override
    public void mouseMove(int x, int y) {
        super.mouseMove(x, y);
        x -= this.bounds.x;
        y -= this.bounds.y;
        if (this.focus != null) {
            this.focus.mouseMove(x, y);
        } else {
            for (Widget child : this.children) {
                if (!child.in(x, y) || !child.isVisible()) continue;
                child.mouseMove(x, y);
                return;
            }
        }
    }
}

