/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import ftb.lib.FTBLib;
import ftb.lib.api.GameMode;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import latmod.lib.LMFileUtils;
import latmod.lib.LMJsonUtils;

public class GameModes {
    public final Map<String, GameMode> modes;
    public final GameMode defaultMode;
    public final GameMode commonMode;
    public final Map<String, String> customData;
    private static GameModes gameModes = null;

    private static JsonObject createDefault() {
        JsonObject o = new JsonObject();
        JsonArray a = new JsonArray();
        a.add((JsonElement)new JsonPrimitive("default"));
        o.add("modes", (JsonElement)a);
        o.add("default", (JsonElement)new JsonPrimitive("default"));
        o.add("common", (JsonElement)new JsonPrimitive("common"));
        return o;
    }

    private static boolean isValid(JsonElement e) {
        if (e == null || !e.isJsonObject()) {
            return false;
        }
        JsonObject o = e.getAsJsonObject();
        if (o == null || o.entrySet().isEmpty()) {
            return false;
        }
        return o.has("modes") && o.has("default") && o.has("common");
    }

    public GameModes(JsonElement el) {
        JsonObject o = GameModes.isValid(el) ? el.getAsJsonObject() : GameModes.createDefault();
        HashMap<String, GameMode> modes0 = new HashMap<String, GameMode>();
        JsonArray a = o.get("modes").getAsJsonArray();
        for (int i = 0; i < a.size(); ++i) {
            GameMode m = new GameMode(a.get(i).getAsString());
            modes0.put(m.getID(), m);
        }
        this.defaultMode = (GameMode)modes0.get(o.get("default").getAsString());
        String common = o.get("common").getAsString();
        if (modes0.containsKey(common)) {
            throw new RuntimeException("FTBLib: common mode name can't be one of 'modes'!");
        }
        this.commonMode = new GameMode(common);
        this.modes = Collections.unmodifiableMap(modes0);
        HashMap customData0 = new HashMap();
        if (o.has("custom")) {
            JsonObject o1 = o.get("custom").getAsJsonObject();
            for (Map.Entry e : o1.entrySet()) {
                customData0.put(e.getKey(), ((JsonElement)e.getValue()).getAsString());
            }
        }
        this.customData = Collections.unmodifiableMap(customData0);
    }

    public JsonObject toJsonObject() {
        JsonObject o = new JsonObject();
        JsonArray a = new JsonArray();
        for (GameMode m : this.modes.values()) {
            a.add((JsonElement)new JsonPrimitive(m.getID()));
        }
        o.add("modes", (JsonElement)a);
        o.add("default", (JsonElement)new JsonPrimitive(this.defaultMode.getID()));
        o.add("common", (JsonElement)new JsonPrimitive(this.commonMode.getID()));
        if (!this.customData.isEmpty()) {
            JsonObject o1 = new JsonObject();
            for (Map.Entry<String, String> e : this.customData.entrySet()) {
                o1.add(e.getKey(), (JsonElement)new JsonPrimitive(e.getValue()));
            }
            o.add("custom", (JsonElement)o1);
        }
        return o;
    }

    public static void reload() {
        File file = LMFileUtils.newFile(new File(FTBLib.folderModpack, "gamemodes.json"));
        gameModes = new GameModes(LMJsonUtils.fromJson(file));
        LMJsonUtils.toJson(file, (JsonElement)gameModes.toJsonObject());
    }

    public static GameModes getGameModes() {
        if (gameModes == null) {
            GameModes.reload();
        }
        return gameModes;
    }

    public GameMode get(String s) {
        if (s == null || s.isEmpty()) {
            return this.defaultMode;
        }
        GameMode m = this.modes.get(s);
        return m == null ? this.defaultMode : m;
    }
}

