/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.notification;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.api.client.FTBLibClient;
import ftb.lib.api.client.GlStateManager;
import ftb.lib.api.gui.GuiLM;
import ftb.lib.api.notification.Notification;
import java.util.ArrayList;
import java.util.List;
import latmod.lib.LMUtils;
import latmod.lib.util.FinalIDObject;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

@SideOnly(value=Side.CLIENT)
public class ClientNotifications {
    private static Temp current = null;

    public static void renderTemp() {
        if (current != null) {
            if (current.render()) {
                current = null;
            }
        } else if (!Temp.list.isEmpty()) {
            current = Temp.list.get(0);
            Temp.list.remove(0);
        }
    }

    public static void add(Notification n) {
        if (n == null) {
            return;
        }
        Temp.list.remove(n);
        Perm.list.remove(n);
        if (current != null && current.equals(n)) {
            current = null;
        }
        Temp.list.add(new Temp(n));
        if (!n.isTemp()) {
            Perm.list.add(new Perm(n));
        }
    }

    public static void init() {
        current = null;
        Perm.list.clear();
        Temp.list.clear();
    }

    public static class Perm
    extends FinalIDObject {
        public static final List<Perm> list = new ArrayList<Perm>();
        public final Notification notification;
        public final long timeAdded;

        public static void remove(Object o) {
            int index = list.indexOf(o);
            if (index != -1) {
                list.remove(index);
            }
        }

        private Perm(Notification n) {
            super(n.getID());
            this.notification = n;
            this.timeAdded = LMUtils.millis();
        }

        @Override
        public int compareTo(Object o) {
            return Long.compare(((Perm)o).timeAdded, this.timeAdded);
        }

        public void onClicked() {
            if (this.notification.mouse != null && this.notification.mouse.click != null) {
                this.notification.mouse.click.onClicked();
            }
        }
    }

    public static class Temp
    extends FinalIDObject {
        public static final List<Temp> list = new ArrayList<Temp>();
        private long time;
        private Notification notification;
        private String title;
        private String desc;
        private int width;

        private Temp(Notification n) {
            super(n.getID());
            n.item = null;
            this.notification = n;
            this.time = -1L;
            this.title = this.notification.title.func_150254_d();
            this.desc = this.notification.desc == null ? null : this.notification.desc.func_150254_d();
            this.width = 20 + Math.max(FTBLibClient.mc.field_71466_p.func_78256_a(this.title), FTBLibClient.mc.field_71466_p.func_78256_a(this.desc));
            if (this.notification.item != null) {
                this.width += 20;
            }
        }

        public boolean render() {
            if (this.time == -1L) {
                this.time = Minecraft.func_71386_F();
            }
            if (this.time > 0L) {
                double d0 = (double)(Minecraft.func_71386_F() - this.time) / (double)this.notification.timer;
                if (d0 < 0.0 || d0 > 1.0) {
                    this.time = 0L;
                    return true;
                }
                double d1 = d0 * 2.0;
                if (d1 > 1.0) {
                    d1 = 2.0 - d1;
                }
                d1 *= 4.0;
                if ((d1 = 1.0 - d1) < 0.0) {
                    d1 = 0.0;
                }
                d1 *= d1;
                d1 *= d1;
                GlStateManager.disableDepth();
                GlStateManager.pushMatrix();
                GlStateManager.depthMask(false);
                GlStateManager.translate((double)(FTBLibClient.displayW - this.width), -d1 * 36.0, 0.0);
                GlStateManager.disableTexture2D();
                GlStateManager.disableLighting();
                FTBLibClient.setGLColor(this.notification.color, 230);
                GuiLM.drawBlankRect(0.0, 0.0, 0.0, FTBLibClient.displayW, 32.0);
                GlStateManager.enableTexture2D();
                GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
                int w = this.notification.item == null ? 10 : 30;
                FontRenderer font = FTBLibClient.mc.field_71466_p;
                if (this.desc == null) {
                    font.func_78276_b(this.title, w, 12, -1);
                } else {
                    font.func_78276_b(this.title, w, 7, -1);
                    font.func_78276_b(this.desc, w, 18, -1);
                }
                if (this.notification.item != null) {
                    // empty if block
                }
                GlStateManager.depthMask(true);
                GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
                GlStateManager.popMatrix();
                GlStateManager.enableLighting();
            }
            return this.time == 0L;
        }
    }
}

