/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.recipe;

import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import openblocks.common.item.ItemEpicEraser;
import openmods.utils.InventoryUtils;

public class EpicEraserRecipe
implements IRecipe {
    private static boolean hasLore(ItemStack itemStack) {
        NBTTagCompound itemTag = itemStack.func_77978_p();
        if (itemTag != null && itemTag.func_150297_b("display", 10)) {
            NBTTagCompound displayTag = itemTag.func_74775_l("display");
            return displayTag.func_150297_b("SillyLore", 9) || displayTag.func_150297_b("Lore", 9);
        }
        return false;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        boolean eraserFound = false;
        boolean loreItemFound = false;
        for (ItemStack itemStack : InventoryUtils.asIterable((IInventory)inv)) {
            if (itemStack == null) continue;
            if (itemStack.func_77973_b() instanceof ItemEpicEraser) {
                if (eraserFound) {
                    return false;
                }
                eraserFound = true;
                continue;
            }
            if (EpicEraserRecipe.hasLore(itemStack)) {
                if (loreItemFound) {
                    return false;
                }
                loreItemFound = true;
                continue;
            }
            return false;
        }
        return eraserFound && loreItemFound;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack targetItem = null;
        boolean eraserFound = false;
        for (ItemStack itemStack : InventoryUtils.asIterable((IInventory)inv)) {
            if (itemStack == null) continue;
            if (itemStack.func_77973_b() instanceof ItemEpicEraser) {
                if (eraserFound) {
                    return null;
                }
                eraserFound = true;
                continue;
            }
            if (EpicEraserRecipe.hasLore(itemStack)) {
                if (targetItem != null) {
                    return null;
                }
                targetItem = itemStack;
                continue;
            }
            return null;
        }
        if (!eraserFound || targetItem == null) {
            return null;
        }
        ItemStack result = targetItem.func_77946_l();
        NBTTagCompound itemTag = result.func_77978_p();
        NBTTagCompound displayTag = itemTag.func_74775_l("display");
        displayTag.func_82580_o("Lore");
        displayTag.func_82580_o("SillyLore");
        return result;
    }

    public int func_77570_a() {
        return 2;
    }

    public ItemStack func_77571_b() {
        return null;
    }
}

