/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.gui.element;

import com.xcompwiz.mystcraft.api.item.IItemRenameable;
import com.xcompwiz.mystcraft.client.gui.GuiUtils;
import com.xcompwiz.mystcraft.client.gui.element.GuiElement;
import com.xcompwiz.mystcraft.data.Assets;
import com.xcompwiz.mystcraft.words.DrawableWordManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GuiElementSurfaceTabs
extends GuiElement {
    private IGuiSurfaceTabsHandler listener;
    private static final int windowsizeY = 166;
    private static final byte tabCount = 4;

    public GuiElementSurfaceTabs(IGuiSurfaceTabsHandler eventhandler, int guiLeft, int guiTop, int width, int height) {
        super(guiLeft, guiTop, width, height);
        this.listener = eventhandler;
    }

    private void cycleTabUp() {
        byte topslot = this.getTopSlot();
        if (topslot == 0) {
            return;
        }
        topslot = (byte)(topslot - 1);
        this.listener.setTopTabSlot(topslot);
    }

    private void cycleTabDown() {
        byte topslot = this.getTopSlot();
        if (topslot == this.getMaxTabCount() - 4) {
            return;
        }
        topslot = (byte)(topslot + 1);
        this.listener.setTopTabSlot(topslot);
    }

    @Override
    public boolean _onKeyPress(char c, int i) {
        if (i == 200 || i == this.mc.field_71474_y.field_74351_w.func_151463_i()) {
            this.cycleTabUp();
            return true;
        }
        if (i == 208 || i == this.mc.field_71474_y.field_74368_y.func_151463_i()) {
            this.cycleTabDown();
            return true;
        }
        return false;
    }

    @Override
    public boolean _onMouseDown(int x, int y, int button) {
        int guiTop;
        int tabY;
        byte topslot = this.getTopSlot();
        int guiLeft = this.getLeft();
        if (GuiUtils.contains(x, y, guiLeft, tabY = (guiTop = this.getTop()), 58, 9)) {
            this.cycleTabUp();
            return true;
        }
        tabY += 9;
        for (byte slot = topslot; slot < topslot + 4; slot = (byte)(slot + 1)) {
            if (GuiUtils.contains(x, y, guiLeft, tabY + 1, 58, 35) && !GuiUtils.contains(x, y, guiLeft + 35, tabY + 2, 19, 19)) {
                this.listener.onSurfaceTabClick(button, slot);
                return true;
            }
            tabY += 37;
        }
        if (GuiUtils.contains(x, y, guiLeft, tabY, 58, 9)) {
            this.cycleTabDown();
            return true;
        }
        return false;
    }

    @Override
    public void _renderBackground(float f, int mouseX, int mouseY) {
        int guiLeft = this.getLeft();
        int guiTop = this.getTop();
        byte topslot = this.getTopSlot();
        int tabY = guiTop;
        int xSizeTab = 58;
        int ySizeTab = 37;
        byte activeslot = this.getActiveTab();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (activeslot < topslot) {
            GL11.glColor4f((float)0.5f, (float)0.5f, (float)1.0f, (float)1.0f);
        }
        if (topslot == 0) {
            GL11.glColor4f((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
        }
        this.mc.field_71446_o.func_110577_a(Assets.GUIs.desk);
        this.func_73729_b(guiLeft, tabY, 0, 166 + ySizeTab, xSizeTab, 9);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tabY += 9;
        for (byte i = topslot; i < topslot + 4; i = (byte)(i + 1)) {
            if (i == activeslot) {
                GL11.glColor4f((float)0.5f, (float)0.5f, (float)1.0f, (float)1.0f);
            }
            this.mc.field_71446_o.func_110577_a(Assets.GUIs.desk);
            this.func_73729_b(guiLeft, tabY, 0, 166, xSizeTab, ySizeTab);
            GuiUtils.drawWord(this.mc.field_71446_o, this.getZLevel(), DrawableWordManager.getDrawableWord("" + i), 19.0f, guiLeft + 8, tabY + 3);
            ItemStack pagesource = this.getTabContents(i);
            if (pagesource != null) {
                String name = null;
                name = pagesource.func_77973_b() instanceof IItemRenameable ? ((IItemRenameable)pagesource.func_77973_b()).getDisplayName((EntityPlayer)this.mc.field_71439_g, pagesource) : pagesource.func_82833_r();
                if (name != null) {
                    GL11.glPushMatrix();
                    float scale = 1.0f;
                    int j = this.mc.field_71466_p.func_78256_a(name) + 16;
                    if (j > xSizeTab) {
                        scale = (float)xSizeTab / (float)j;
                    }
                    GL11.glTranslatef((float)(guiLeft + 4), (float)(tabY + 25), (float)0.0f);
                    GL11.glScalef((float)scale, (float)scale, (float)1.0f);
                    this.mc.field_71466_p.func_78276_b(name, 0, 0, 0x404040);
                    GL11.glPopMatrix();
                }
            }
            tabY += ySizeTab;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.mc.field_71446_o.func_110577_a(Assets.GUIs.desk);
        if (activeslot >= topslot + 4) {
            GL11.glColor4f((float)0.5f, (float)0.5f, (float)1.0f, (float)1.0f);
        }
        if (topslot + 4 == this.getMaxTabCount()) {
            GL11.glColor4f((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
        }
        this.func_73729_b(guiLeft, tabY, 0, 166 + ySizeTab + 9, xSizeTab, 9);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private byte getTopSlot() {
        return this.listener.getTopSlot();
    }

    private byte getActiveTab() {
        return this.listener.getActiveTab();
    }

    private int getMaxTabCount() {
        return 25;
    }

    private ItemStack getTabContents(byte slot) {
        return this.listener.getItemInSlot(slot);
    }

    public static interface IGuiSurfaceTabsHandler {
        public ItemStack getItemInSlot(byte var1);

        public void setTopTabSlot(int var1);

        public void onSurfaceTabClick(int var1, byte var2);

        public byte getTopSlot();

        public byte getActiveTab();
    }
}

