/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.data;

import com.xcompwiz.mystcraft.api.impl.InternalAPI;
import com.xcompwiz.mystcraft.api.symbol.BlockCategory;
import com.xcompwiz.mystcraft.config.MystConfig;
import com.xcompwiz.mystcraft.data.ModSymbolsModifiers;
import com.xcompwiz.mystcraft.instability.InstabilityBlockManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class ModSymbolsFluids {
    private static MystConfig config;
    private static MystConfig refconfig;
    private static Collection<Fluid> blacklist;
    private static Map<String, FluidData> defaults;
    private static FluidData defaultfluidvals;
    private static Map<String, Boolean> bannedsea;
    private static Map<String, Integer> cardranks;
    private static Map<String, Integer> grammarranks;
    private static Map<String, Float> factor1s;
    private static Map<String, Float> factor2s;

    public static void setConfig(MystConfig mystconfig) {
        config = mystconfig;
    }

    public static void setReferenceConfig(MystConfig mystconfig) {
        refconfig = mystconfig;
    }

    public static void init() {
        ModSymbolsFluids.loadDefaults();
    }

    public static void modsLoaded() {
        Map map = FluidRegistry.getRegisteredFluids();
        for (Map.Entry entry : map.entrySet()) {
            Block block;
            Fluid fluid = (Fluid)entry.getValue();
            if (blacklist.contains(fluid) || (block = fluid.getBlock()) == Blocks.field_150355_j || block == Blocks.field_150353_l || block == null || Item.func_150898_a((Block)block) == null) continue;
            byte meta = 0;
            if (block instanceof BlockFluidBase) {
                meta = (byte)((BlockFluidBase)block).getMaxRenderHeightMeta();
            }
            String fluidkey = ModSymbolsFluids.getFluidKey(fluid);
            ModSymbolsModifiers.BlockModifierContainerObject container = ModSymbolsModifiers.BlockModifierContainerObject.create("Flow", (int)ModSymbolsFluids.symbolCardRank(fluidkey), block, meta);
            InstabilityBlockManager.setInstabilityFactors(block, ModSymbolsFluids.factor1(fluidkey), ModSymbolsFluids.factor2(fluidkey));
            if (fluid.isGaseous()) {
                container.add(BlockCategory.GAS, ModSymbolsFluids.grammarRank(fluidkey));
            } else {
                if (!ModSymbolsFluids.isBannedSea(fluidkey)) {
                    container.add(BlockCategory.SEA, ModSymbolsFluids.grammarRank(fluidkey));
                }
                container.add(BlockCategory.FLUID, ModSymbolsFluids.grammarRank(fluidkey));
            }
            if (container.getSymbol() == null) continue;
            InternalAPI.symbol.registerSymbol(container.getSymbol(), "Mystcraft");
        }
        if (config != null && config.hasChanged()) {
            config.save();
        }
        if (refconfig != null && refconfig.hasChanged()) {
            refconfig.save();
        }
    }

    public static void blacklist(Fluid fluid) {
        blacklist.add(fluid);
    }

    public static FluidData getDefault(String fluidname) {
        FluidData data = defaults.get(fluidname);
        if (data == null) {
            data = new FluidData();
            defaults.put(fluidname, data);
        }
        return data;
    }

    private static FluidData getDefaultValue(String fluidkey) {
        FluidData data = defaults.get(fluidkey);
        if (data != null) {
            return data;
        }
        return defaultfluidvals;
    }

    private static boolean isBannedSea(String fluidkey) {
        Boolean value = bannedsea.get(fluidkey);
        if (value != null) {
            return value;
        }
        boolean val = ModSymbolsFluids.getDefaultValue((String)fluidkey).seabanned;
        if (refconfig != null) {
            refconfig.get("fluids", fluidkey + ".seabanned", val).set(val);
        }
        if (config != null) {
            return config.getOptional("fluids", fluidkey + ".seabanned", val);
        }
        return val;
    }

    private static Integer symbolCardRank(String fluidkey) {
        Integer value = cardranks.get(fluidkey);
        if (value != null) {
            return value;
        }
        int val = ModSymbolsFluids.getDefaultValue((String)fluidkey).cardrank;
        if (refconfig != null) {
            refconfig.get("fluids", fluidkey + ".cardrank", val).set(val);
        }
        if (config != null) {
            return config.getOptional("fluids", fluidkey + ".cardrank", val);
        }
        return val;
    }

    private static Integer grammarRank(String fluidkey) {
        Integer value = grammarranks.get(fluidkey);
        if (value != null) {
            return value;
        }
        int val = ModSymbolsFluids.getDefaultValue((String)fluidkey).grammar;
        if (refconfig != null) {
            refconfig.get("fluids", fluidkey + ".grammar", val).set(val);
        }
        if (config != null) {
            return config.getOptional("fluids", fluidkey + ".grammar", val);
        }
        return val;
    }

    private static float factor1(String fluidkey) {
        Float value = factor1s.get(fluidkey);
        if (value != null) {
            return value.floatValue();
        }
        float val = ModSymbolsFluids.getDefaultValue((String)fluidkey).factor1;
        if (refconfig != null) {
            refconfig.get("fluids", fluidkey + ".instability.factor_accessibility", val).set((double)val);
        }
        if (config != null) {
            return config.getOptional("fluids", fluidkey + ".instability.factor_accessibility", val);
        }
        return val;
    }

    private static float factor2(String fluidkey) {
        Float value = factor2s.get(fluidkey);
        if (value != null) {
            return value.floatValue();
        }
        float val = ModSymbolsFluids.getDefaultValue((String)fluidkey).factor2;
        if (refconfig != null) {
            refconfig.get("fluids", fluidkey + ".instability.factor_flat", val).set((double)val);
        }
        if (config != null) {
            return config.getOptional("fluids", fluidkey + ".instability.factor_flat", val);
        }
        return val;
    }

    private static String getFluidKey(Fluid fluid) {
        return fluid.getUnlocalizedName().toLowerCase().replace(' ', '_');
    }

    public static void setSeaBanned(Fluid fluid, boolean value) {
        bannedsea.put(ModSymbolsFluids.getFluidKey(fluid), value);
    }

    public static void setCardRank(Fluid fluid, Integer value) {
        cardranks.put(ModSymbolsFluids.getFluidKey(fluid), value);
    }

    public static void setGrammarRank(Fluid fluid, Integer value) {
        grammarranks.put(ModSymbolsFluids.getFluidKey(fluid), value);
    }

    public static void setFactor1(Fluid fluid, float value) {
        factor1s.put(ModSymbolsFluids.getFluidKey(fluid), Float.valueOf(value));
    }

    public static void setFactor2(Fluid fluid, float value) {
        factor2s.put(ModSymbolsFluids.getFluidKey(fluid), Float.valueOf(value));
    }

    private static void loadDefaults() {
        ModSymbolsFluids.getDefault("fluid.mobessence").setBannedSea(false).setFactor1(98.0f).setFactor2(7.0f);
        ModSymbolsFluids.getDefault("fluid.ender").setBannedSea(true).setFactor1(72.0f).setFactor2(6.0f);
        ModSymbolsFluids.getDefault("fluid.manyullyn.molten").setBannedSea(true).setFactor1(72.0f).setFactor2(6.0f);
        ModSymbolsFluids.getDefault("fluid.redstone").setBannedSea(true).setFactor1(72.0f).setFactor2(6.0f);
        ModSymbolsFluids.getDefault("fluid.fluiduumatter").setBannedSea(true).setFactor1(32.0f).setFactor2(4.0f);
        ModSymbolsFluids.getDefault("fluid.life_essence").setBannedSea(false).setFactor1(32.0f).setFactor2(4.0f);
        ModSymbolsFluids.getDefault("fluid.alumite.molten").setBannedSea(true).setFactor1(18.0f).setFactor2(3.0f);
        ModSymbolsFluids.getDefault("fluid.ardite.molten").setBannedSea(true).setFactor1(18.0f).setFactor2(3.0f);
        ModSymbolsFluids.getDefault("fluid.cobalt.molten").setBannedSea(true).setFactor1(18.0f).setFactor2(3.0f);
        ModSymbolsFluids.getDefault("fluid.fluid.purity").setBannedSea(false).setFactor1(18.0f).setFactor2(3.0f);
        ModSymbolsFluids.getDefault("fluid.aluminum.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        ModSymbolsFluids.getDefault("fluid.biofuel").setBannedSea(false).setFactor1(8.0f).setFactor2(2.0f);
        ModSymbolsFluids.getDefault("fluid.bronze.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        ModSymbolsFluids.getDefault("fluid.chocolatemilk").setBannedSea(false).setFactor1(8.0f).setFactor2(2.0f);
        ModSymbolsFluids.getDefault("fluid.copper.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        ModSymbolsFluids.getDefault("fluid.creosote").setBannedSea(false).setFactor1(8.0f).setFactor2(2.0f);
        ModSymbolsFluids.getDefault("fluid.electrum.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        ModSymbolsFluids.getDefault("fluid.emerald.liquid").setBannedSea(false).setFactor1(8.0f).setFactor2(2.0f);
        ModSymbolsFluids.getDefault("fluid.fluidbiogas").setBannedSea(false).setFactor1(8.0f).setFactor2(2.0f);
        ModSymbolsFluids.getDefault("fluid.fluidbiomass").setBannedSea(false).setFactor1(8.0f).setFactor2(2.0f);
        ModSymbolsFluids.getDefault("fluid.fuel").setBannedSea(false).setFactor1(8.0f).setFactor2(2.0f);
        ModSymbolsFluids.getDefault("fluid.gold.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        ModSymbolsFluids.getDefault("fluid.invar.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        ModSymbolsFluids.getDefault("fluid.iron.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        ModSymbolsFluids.getDefault("fluid.lead.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        ModSymbolsFluids.getDefault("fluid.nickel.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        ModSymbolsFluids.getDefault("fluid.obsidian.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        ModSymbolsFluids.getDefault("fluid.platinum.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        ModSymbolsFluids.getDefault("fluid.silver.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        ModSymbolsFluids.getDefault("fluid.steel.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        ModSymbolsFluids.getDefault("fluid.tin.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        ModSymbolsFluids.getDefault("fluid.aluminumbrass.molten").setBannedSea(true).setFactor1(2.0f).setFactor2(1.0f);
        ModSymbolsFluids.getDefault("fluid.coal").setBannedSea(false).setFactor1(2.0f).setFactor2(1.0f);
        ModSymbolsFluids.getDefault("fluid.glass.molten").setBannedSea(false).setFactor1(2.0f).setFactor2(1.0f);
        ModSymbolsFluids.getDefault("fluid.glowstone").setBannedSea(false).setFactor1(2.0f).setFactor2(1.0f);
        ModSymbolsFluids.getDefault("fluid.honey").setBannedSea(false).setFactor1(1.0f).setFactor2(0.0f);
        ModSymbolsFluids.getDefault("fluid.oil").setBannedSea(false).setFactor1(1.0f).setFactor2(0.0f);
        ModSymbolsFluids.getDefault("fluid.spring_water").setBannedSea(false).setFactor1(2.0f).setFactor2(1.0f);
        ModSymbolsFluids.getDefault("fluid.witchery:fluidspirit").setBannedSea(false).setFactor1(2.0f).setFactor2(1.0f);
        ModSymbolsFluids.getDefault("fluid.meat").setBannedSea(false).setFactor1(1.0f).setFactor2(0.0f);
        ModSymbolsFluids.getDefault("fluid.myst.ink.black").setBannedSea(false).setFactor1(1.0f).setFactor2(0.0f);
        ModSymbolsFluids.getDefault("fluid.blood").setBannedSea(false).setFactor1(0.0f).setFactor2(0.0f);
        ModSymbolsFluids.getDefault("fluid.fluidconstructionfoam").setBannedSea(false).setFactor1(0.0f).setFactor2(0.0f);
        ModSymbolsFluids.getDefault("fluid.fluidcoolant").setBannedSea(false).setFactor1(0.0f).setFactor2(0.0f);
        ModSymbolsFluids.getDefault("fluid.fluiddistilledwater").setBannedSea(false).setFactor1(0.0f).setFactor2(0.0f);
        ModSymbolsFluids.getDefault("fluid.fluidpahoehoelava").setBannedSea(false).setFactor1(0.0f).setFactor2(0.0f);
        ModSymbolsFluids.getDefault("fluid.fluidsteam").setBannedSea(false).setFactor1(0.0f).setFactor2(0.0f);
        ModSymbolsFluids.getDefault("fluid.fluidsuperheatedsteam").setBannedSea(false).setFactor1(0.0f).setFactor2(0.0f);
        ModSymbolsFluids.getDefault("fluid.glue").setBannedSea(true).setFactor1(0.0f).setFactor2(0.0f);
        ModSymbolsFluids.getDefault("fluid.milk").setBannedSea(false).setFactor1(0.0f).setFactor2(0.0f);
        ModSymbolsFluids.getDefault("fluid.mushroomsoup").setBannedSea(false).setFactor1(0.0f).setFactor2(0.0f);
        ModSymbolsFluids.getDefault("fluid.steam").setBannedSea(false).setFactor1(0.0f).setFactor2(0.0f);
        ModSymbolsFluids.getDefault("fluid.stone.seared").setBannedSea(false).setFactor1(0.0f).setFactor2(0.0f);
        ModSymbolsFluids.getDefault("fluid.slime.blue").setBannedSea(false).setFactor1(-0.5f).setFactor2(-0.5f);
        ModSymbolsFluids.getDefault("fluid.cryotheum").setBannedSea(false).setFactor1(-2.0f).setFactor2(-1.0f);
        ModSymbolsFluids.getDefault("fluid.etchacid").setBannedSea(false).setFactor1(-2.0f).setFactor2(-1.0f);
        ModSymbolsFluids.getDefault("fluid.fluid.death").setBannedSea(false).setFactor1(-2.0f).setFactor2(-1.0f);
        ModSymbolsFluids.getDefault("fluid.fluidhotcoolant").setBannedSea(false).setFactor1(-2.0f).setFactor2(-1.0f);
        ModSymbolsFluids.getDefault("fluid.poison").setBannedSea(false).setFactor1(-2.0f).setFactor2(-1.0f);
        ModSymbolsFluids.getDefault("fluid.sewage").setBannedSea(false).setFactor1(-2.0f).setFactor2(-1.0f);
        ModSymbolsFluids.getDefault("fluid.sludge").setBannedSea(false).setFactor1(-2.0f).setFactor2(-1.0f);
        ModSymbolsFluids.getDefault("fluid.witchery:hollowtears").setBannedSea(false).setFactor1(-2.0f).setFactor2(-1.0f);
        ModSymbolsFluids.getDefault("fluid.mana").setBannedSea(false).setFactor1(-6.0f).setFactor2(-2.0f);
        ModSymbolsFluids.getDefault("fluid.pyrotheum").setBannedSea(false).setFactor1(-6.0f).setFactor2(-2.0f);
        ModSymbolsFluids.getDefault("fluid.fluxgoo").setBannedSea(true).setFactor1(-12.0f).setFactor2(-3.0f);
    }

    static {
        blacklist = new HashSet<Fluid>();
        defaults = new HashMap<String, FluidData>();
        defaultfluidvals = new FluidData();
        bannedsea = new HashMap<String, Boolean>();
        cardranks = new HashMap<String, Integer>();
        grammarranks = new HashMap<String, Integer>();
        factor1s = new HashMap<String, Float>();
        factor2s = new HashMap<String, Float>();
    }

    public static class FluidData {
        public boolean seabanned = false;
        public int grammar = 4;
        public int cardrank = 4;
        public float factor1 = 1.0f;
        public float factor2 = 0.25f;

        public FluidData setBannedSea(boolean b) {
            this.seabanned = b;
            return this;
        }

        public FluidData setGrammarRank(int v) {
            this.grammar = v;
            return this;
        }

        public FluidData setCardRank(int v) {
            this.cardrank = v;
            return this;
        }

        public FluidData setFactor1(float v) {
            this.factor1 = v;
            return this;
        }

        public FluidData setFactor2(float v) {
            this.factor2 = v;
            return this;
        }
    }
}

