/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.integration.lookingglass;

import com.xcompwiz.lookingglass.api.animator.CameraAnimatorPivot;
import com.xcompwiz.lookingglass.api.animator.ICameraAnimator;
import com.xcompwiz.lookingglass.api.view.IWorldView;
import com.xcompwiz.mystcraft.api.client.ILinkPanelEffect;
import com.xcompwiz.mystcraft.api.linking.ILinkInfo;
import com.xcompwiz.mystcraft.integration.lookingglass.ILookingGlassWrapper;
import com.xcompwiz.mystcraft.linking.DimensionUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;

@SideOnly(value=Side.CLIENT)
public class DynamicLinkPanelRenderer
implements ILinkPanelEffect {
    private final ILookingGlassWrapper apiinst;
    private Random rand;
    public static int shaderARB;
    public static int vertexARB;
    public static int fragmentARB;
    public static int textureLoc;
    public static int damageLoc;
    public static int resLoc;
    public static int timeLoc;
    public static int waveScaleLoc;
    public static int colorScaleLoc;
    public static int linkColorLoc;
    private Integer activeDim;
    private ChunkCoordinates activeCoords;
    private IWorldView activeview;
    public float colorScale = 0.5f;
    public float waveScale = 0.5f;
    private long readyTime;
    private boolean ready;

    public DynamicLinkPanelRenderer(ILookingGlassWrapper apiinst) {
        this.apiinst = apiinst;
        this.rand = new Random();
    }

    @Override
    public void render(int left, int top, int width, int height, ILinkInfo linkinfo, ItemStack bookclone) {
        boolean useshaders;
        if (this.activeview != null && this.detectLinkInfoChange(linkinfo)) {
            this.apiinst.release(this.activeview);
            this.activeview = null;
        }
        if (linkinfo == null) {
            return;
        }
        Integer dimid = linkinfo.getDimensionUID();
        if (dimid == null) {
            return;
        }
        if (this.activeview == null) {
            ChunkCoordinates spawn = linkinfo.getSpawn();
            this.activeview = this.apiinst.createWorldView(dimid, spawn, 132, 83);
            if (this.activeview != null) {
                this.activeview.setAnimator((ICameraAnimator)new CameraAnimatorPivot(this.activeview.getCamera()));
                this.activeDim = dimid;
                this.activeCoords = linkinfo.getSpawn();
            }
            this.colorScale = 0.5f;
            this.waveScale = 0.5f;
            this.readyTime = -1L;
            this.ready = false;
        }
        if (this.activeview == null) {
            return;
        }
        int texture = this.activeview.getTexture();
        if (texture == 0) {
            return;
        }
        float bookDamage = 0.0f;
        if (bookclone != null) {
            bookDamage = (float)bookclone.func_77952_i() / (float)bookclone.func_77958_k();
        }
        if (useshaders = OpenGlHelper.field_148824_g) {
            float sinceOpened = 0.0f;
            if (!this.ready && this.activeview.isReady()) {
                this.ready = true;
                this.readyTime = Minecraft.func_71386_F();
            }
            if (this.readyTime >= 0L) {
                sinceOpened = (float)(Minecraft.func_71386_F() - this.readyTime) * 3.0E-4f;
            }
            int color = DimensionUtils.getLinkColor(linkinfo);
            float linkColorR = (float)(color >> 16 & 0xFF) / 255.0f;
            float linkColorG = (float)(color >> 8 & 0xFF) / 255.0f;
            float linkColorB = (float)(color & 0xFF) / 255.0f;
            this.waveScale = (float)((double)this.waveScale + (this.rand.nextDouble() - 0.5) / 10.0);
            if (this.waveScale > 1.0f) {
                this.waveScale = 1.0f;
            }
            if (this.waveScale < 0.0f) {
                this.waveScale = 0.0f;
            }
            this.colorScale = (float)((double)this.colorScale + (this.rand.nextDouble() - 0.5) / 10.0);
            if (this.colorScale > 1.0f) {
                this.colorScale = 1.0f;
            }
            if (this.colorScale < 0.5f) {
                this.colorScale = 0.5f;
            }
            ARBShaderObjects.glUseProgramObjectARB((int)shaderARB);
            ARBShaderObjects.glUniform1iARB((int)textureLoc, (int)14);
            GL13.glActiveTexture((int)33998);
            GL11.glBindTexture((int)3553, (int)texture);
            ARBShaderObjects.glUniform1fARB((int)timeLoc, (float)sinceOpened);
            ARBShaderObjects.glUniform2fARB((int)resLoc, (float)width, (float)height);
            ARBShaderObjects.glUniform1fARB((int)damageLoc, (float)((bookDamage - 0.5f) * 2.0f));
            ARBShaderObjects.glUniform1fARB((int)waveScaleLoc, (float)0.0f);
            ARBShaderObjects.glUniform1fARB((int)colorScaleLoc, (float)this.colorScale);
            ARBShaderObjects.glUniform4fARB((int)linkColorLoc, (float)linkColorR, (float)linkColorG, (float)linkColorB, (float)1.0f);
            GL13.glActiveTexture((int)33984);
        } else if (!this.activeview.isReady()) {
            return;
        }
        GL11.glBindTexture((int)3553, (int)texture);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78369_a(0.0f, 0.0f, 0.0f, 1.0f);
        tessellator.func_78382_b();
        if (useshaders) {
            tessellator.func_78374_a((double)left, (double)(height + top), 0.0, 0.0, 1.0);
            tessellator.func_78374_a((double)(width + left), (double)(height + top), 0.0, 1.0, 1.0);
            tessellator.func_78374_a((double)(width + left), (double)top, 0.0, 1.0, 0.0);
            tessellator.func_78374_a((double)left, (double)top, 0.0, 0.0, 0.0);
        } else {
            tessellator.func_78374_a((double)left, (double)(height + top), 0.0, 0.0, 0.0);
            tessellator.func_78374_a((double)(width + left), (double)(height + top), 0.0, 1.0, 0.0);
            tessellator.func_78374_a((double)(width + left), (double)top, 0.0, 1.0, 1.0);
            tessellator.func_78374_a((double)left, (double)top, 0.0, 0.0, 1.0);
        }
        tessellator.func_78381_a();
        GL11.glBindTexture((int)3553, (int)0);
        if (useshaders) {
            ARBShaderObjects.glUseProgramObjectARB((int)0);
        }
        this.activeview.markDirty();
    }

    private boolean detectLinkInfoChange(ILinkInfo linkinfo) {
        if (this.activeDim == null && linkinfo == null) {
            return false;
        }
        if (this.activeDim != null && linkinfo == null) {
            this.activeDim = null;
            this.activeCoords = null;
            return true;
        }
        if (this.activeDim != linkinfo.getDimensionUID() || !this.compareCoords(this.activeCoords, linkinfo.getSpawn())) {
            this.activeDim = null;
            this.activeCoords = null;
            return true;
        }
        return false;
    }

    private boolean compareCoords(ChunkCoordinates coords, ChunkCoordinates spawn) {
        if (coords == spawn) {
            return true;
        }
        if (coords == null && spawn != null) {
            return false;
        }
        return coords.equals((Object)spawn);
    }

    @Override
    public void onOpen() {
        this.readyTime = -1L;
        this.ready = false;
    }
}

