/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.inventory;

import com.xcompwiz.mystcraft.inventory.ContainerBase;
import com.xcompwiz.mystcraft.inventory.InventoryVillager;
import com.xcompwiz.mystcraft.inventory.SlotCollection;
import com.xcompwiz.mystcraft.network.IGuiMessageHandler;
import com.xcompwiz.mystcraft.network.packet.MPacketGuiMessage;
import com.xcompwiz.mystcraft.villager.VillagerTradeSystem;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import java.util.ArrayList;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;

public class ContainerVillagerShop
extends ContainerBase
implements IGuiMessageHandler {
    private InventoryPlayer inventoryplayer;
    private EntityVillager villager;
    private InventoryVillager villagerinv;
    private long villagerinv_timestamp;
    private Integer playerEmeralds;
    private long lastEmeraldsUpdate;

    public ContainerVillagerShop(InventoryPlayer inventoryplayer, EntityVillager villager) {
        this.inventoryplayer = inventoryplayer;
        this.villager = villager;
        this.villagerinv = VillagerTradeSystem.getVillagerInventory(villager);
        this.updateSlots();
    }

    public void updateSlots() {
        int i;
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)this.inventoryplayer, j + i * 9 + 9, 8 + j * 18, 99 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.inventoryplayer, i, 8 + i * 18, 157));
        }
        this.collections.clear();
        SlotCollection maininv = null;
        SlotCollection hotbar = null;
        maininv = new SlotCollection(this, 0, 27);
        hotbar = new SlotCollection(this, 27, 36);
        maininv.pushTargetFront(hotbar);
        hotbar.pushTargetFront(maininv);
        this.collections.add(maininv);
        this.collections.add(hotbar);
    }

    public void func_75142_b() {
        ArrayList<FMLProxyPacket> packets = new ArrayList<FMLProxyPacket>();
        for (int slotId = 0; slotId < this.field_75151_b.size(); ++slotId) {
            ItemStack actual = ((Slot)this.field_75151_b.get(slotId)).func_75211_c();
            ItemStack stored = (ItemStack)this.field_75153_a.get(slotId);
            if (ItemStack.func_77989_b((ItemStack)stored, (ItemStack)actual)) continue;
            stored = actual == null ? null : actual.func_77946_l();
            this.field_75153_a.set(slotId, stored);
            for (int var4 = 0; var4 < this.field_75149_d.size(); ++var4) {
                ((ICrafting)this.field_75149_d.get(var4)).func_71111_a((Container)this, slotId, stored);
            }
        }
        if (this.villagerinv_timestamp != this.villagerinv.getLastChanged()) {
            this.villagerinv_timestamp = this.villagerinv.getLastChanged();
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            NBTTagCompound inventorynbt = new NBTTagCompound();
            this.villagerinv.writeToNBT(inventorynbt);
            nbttagcompound.func_74782_a("UVC", (NBTBase)inventorynbt);
            packets.add(MPacketGuiMessage.createPacket(this.field_75152_c, nbttagcompound));
        }
        if (packets.size() > 0) {
            for (int var4 = 0; var4 < this.field_75149_d.size(); ++var4) {
                ICrafting crafter = (ICrafting)this.field_75149_d.get(var4);
                if (!(crafter instanceof EntityPlayerMP)) continue;
                EntityPlayerMP player = (EntityPlayerMP)crafter;
                for (Packet packet : packets) {
                    player.field_71135_a.func_147359_a(packet);
                }
            }
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        if (this.villager.field_70128_L) {
            return false;
        }
        return entityplayer.func_70092_e(this.villager.field_70165_t, this.villager.field_70163_u, this.villager.field_70161_v) <= 64.0;
    }

    @Override
    public void processMessage(EntityPlayer player, NBTTagCompound data) {
        if (data.func_74764_b("UVC")) {
            if (this.villager.field_70170_p.field_72995_K) {
                this.villagerinv.readFromNBT(data.func_74775_l("UVC"));
            }
            return;
        }
        if (data.func_74764_b("PB")) {
            if (this.villagerinv.purchaseBooster(this.inventoryplayer)) {
                this.getPlayerEmeralds(true);
            }
            return;
        }
        if (data.func_74764_b("PI")) {
            int index = data.func_74762_e("PI");
            if (this.villagerinv.purchaseShopItem(this.inventoryplayer, index)) {
                this.getPlayerEmeralds(true);
            }
            return;
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        VillagerTradeSystem.release(this.villagerinv);
        if (this.inventoryplayer.field_70458_d.field_70170_p.field_72995_K) {
            return;
        }
    }

    public ItemStack getShopItem(int index) {
        return this.villagerinv.getShopItem(index);
    }

    public int getShopItemPrice(int index) {
        return this.villagerinv.getShopItemPrice(index);
    }

    public int getBoosterCount() {
        return this.villagerinv.getBoosterCount();
    }

    public int getBoosterCost() {
        return this.villagerinv.getBoosterCost();
    }

    public int getPlayerEmeralds() {
        return this.getPlayerEmeralds(false);
    }

    private int getPlayerEmeralds(boolean forceupdate) {
        if (this.playerEmeralds == null || forceupdate || this.lastEmeraldsUpdate + 100L < this.villager.field_70170_p.func_82737_E()) {
            this.lastEmeraldsUpdate = this.villager.field_70170_p.func_82737_E();
            this.playerEmeralds = this.villagerinv.getPlayerEmeralds(this.inventoryplayer);
        }
        return this.playerEmeralds;
    }

    public static class Messages {
        public static final String UpdateVillagerCollection = "UVC";
        public static final String PurchaseBooster = "PB";
        public static final String PurchaseItem = "PI";
    }
}

