/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.modifiers;

import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.StatCollector;
import net.minecraft.world.biome.BiomeGenBase;

public class SymbolBiome
extends SymbolBase {
    public static ArrayList<BiomeGenBase> selectables = new ArrayList();
    private BiomeGenBase biome;
    private String displayName;

    public SymbolBiome(BiomeGenBase biome) {
        super("Biome" + biome.field_76756_M);
        this.biome = biome;
        this.displayName = SymbolBiome.formatted(biome);
        this.setWords(new String[]{"Nature", "Nurture", "Encourage", biome.field_76791_y + biome.field_76756_M});
    }

    private static String formatted(BiomeGenBase biome) {
        String regex = "([A-Z][a-z]+)";
        String replacement = "$1 ";
        String name = biome.field_76791_y.replaceAll(regex, replacement).replaceAll("([A-Z][a-z]+)  ", replacement).trim();
        if (name.endsWith("Biome")) {
            name = name.substring(0, name.length() - "Biome".length()).trim();
        }
        name = StatCollector.func_74837_a((String)"myst.symbol.biome.wrapper", (Object[])new Object[]{name});
        return name;
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        controller.setAverageGroundLevel((int)(this.biome.field_76748_D * 64.0f + 64.0f));
        ModifierUtils.pushBiome(controller, this.biome);
    }

    @Override
    public String displayName() {
        return this.displayName;
    }

    public static BiomeGenBase getRandomBiome(Random rand) {
        BiomeGenBase biome = null;
        while (biome == null) {
            if (selectables.size() > 0) {
                biome = selectables.get(rand.nextInt(selectables.size()));
                continue;
            }
            biome = BiomeGenBase.func_150568_d((int)rand.nextInt(BiomeGenBase.func_150565_n().length));
        }
        return biome;
    }
}

