/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.util;

import com.xcompwiz.util.Vector;
import com.xcompwiz.util.VectorPool;

public class MathBezier {
    private static float[] sinTable = new float[65536];

    public static final float sin(float angle) {
        return sinTable[(int)(angle * 16384.0f) & 0xFFFF];
    }

    public static final float cos(float angle) {
        return sinTable[(int)(angle * 16384.0f + 16384.0f) & 0xFFFF];
    }

    public static int max(int number1, int number2) {
        return number1 > number2 ? number1 : number2;
    }

    public static float max(float number1, float number2) {
        return number1 > number2 ? number1 : number2;
    }

    public static int min(int number1, int number2) {
        return number1 < number2 ? number1 : number2;
    }

    public static float min(float number1, float number2) {
        return number1 < number2 ? number1 : number2;
    }

    public static int abs(int number) {
        return number < 0 ? -number : number;
    }

    public static float abs(float number) {
        return number < 0.0f ? -number : number;
    }

    public static double abs(double number) {
        return number < 0.0 ? -number : number;
    }

    public static float lerp(float origin, float target, int steps, int maxSteps) {
        return origin + (target - origin) * (float)steps / (float)maxSteps;
    }

    public static double lerp(double origin, double target, int steps, int maxSteps) {
        return origin + (target - origin) * (double)steps / (double)maxSteps;
    }

    public static Vector bezier(Vector[] input, double t) {
        if (input.length < 2) {
            throw new RuntimeException("Need more input points");
        }
        double d = 1.0 - t;
        if (input.length == 2) {
            Vector result = VectorPool.getFreeVector(0.0, 0.0, 0.0);
            for (int i = 0; i < input.length; ++i) {
                Vector vec = input[i].clone();
                if (i == 0) {
                    vec.multiply(t);
                }
                if (i == 1) {
                    vec.multiply(d);
                }
                result.add(vec);
            }
            return result;
        }
        if (input.length == 3) {
            Vector result = VectorPool.getFreeVector(0.0, 0.0, 0.0);
            for (int i = 0; i < input.length; ++i) {
                Vector vec = input[i].clone();
                if (i == 0) {
                    vec.multiply(t * t);
                }
                if (i == 1) {
                    vec.multiply(d * t * 2.0);
                }
                if (i == 2) {
                    vec.multiply(d * d);
                }
                result.add(vec);
            }
            return result;
        }
        if (input.length == 4) {
            Vector result = VectorPool.getFreeVector(0.0, 0.0, 0.0);
            for (int i = 0; i < input.length; ++i) {
                Vector vec = input[i].clone();
                if (i == 0) {
                    vec.multiply(t * t * t);
                }
                if (i == 1) {
                    vec.multiply(d * t * t * 3.0);
                }
                if (i == 2) {
                    vec.multiply(d * d * t * 3.0);
                }
                if (i == 3) {
                    vec.multiply(d * d * d);
                }
                result.add(vec);
            }
            return result;
        }
        throw new RuntimeException("Unknown bezier function");
    }

    static {
        for (int i = 0; i < 65536; ++i) {
            MathBezier.sinTable[i] = (float)Math.sin((double)i * Math.PI * 2.0 / 65536.0);
        }
    }
}

