/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.shader;

import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public abstract class ShaderCase {
    protected final int[] colourUnderlying;
    protected final int[] colourPrimary;
    protected final int[] colourSecondary;
    protected int[] colourOverlay;
    protected static final int[] defaultWhite = new int[]{255, 255, 255, 255};
    protected String overlayType = "0";
    protected String baseTexturePath = "";

    public ShaderCase(String overlayType, int[] colourUnderlying, int[] colourPrimary, int[] colourSecondary, String baseTexturePath) {
        this.overlayType = overlayType;
        this.colourUnderlying = colourUnderlying;
        this.colourPrimary = colourPrimary;
        this.colourSecondary = colourSecondary;
        this.colourOverlay = defaultWhite;
        this.baseTexturePath = baseTexturePath;
    }

    public int[] getUnderlyingColour() {
        return this.colourUnderlying;
    }

    public int[] getPrimaryColour() {
        return this.colourPrimary;
    }

    public int[] getSecondaryColour() {
        return this.colourSecondary;
    }

    public String getOverlayType() {
        return this.overlayType;
    }

    public String getBaseTexturePath() {
        return this.baseTexturePath;
    }

    public ShaderCase setBaseTexturePath(String path) {
        this.baseTexturePath = path;
        return this;
    }

    public ShaderCase setOverlayColour(int ... col) {
        this.colourOverlay = col;
        return this;
    }

    public abstract String getShaderType();

    public abstract int getPasses(ItemStack var1, ItemStack var2, String var3);

    public abstract IIcon getReplacementIcon(ItemStack var1, ItemStack var2, String var3, int var4);

    public abstract void stichTextures(IIconRegister var1, int var2);

    public abstract int[] getRGBAColourModifier(ItemStack var1, ItemStack var2, String var3, int var4);

    public abstract void modifyRender(ItemStack var1, ItemStack var2, String var3, int var4, boolean var5, boolean var6);
}

