/*
 * Decompiled with CFR 0.152.
 */
package covers1624.powerconverters.handler;

import covers1624.powerconverters.PowerConverters;
import covers1624.powerconverters.handler.ConfigurationHandler;
import covers1624.powerconverters.init.Recipes;
import covers1624.powerconverters.net.PacketPipeline;
import covers1624.powerconverters.net.RecipeSyncPacket;
import covers1624.powerconverters.util.IRecipeHandler;
import covers1624.powerconverters.util.LogHelper;
import covers1624.powerconverters.util.RecipeRemover;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidRegistry;

public class PCEventHandler {
    public static int ticksInGame = 0;

    @SubscribeEvent
    public void onFluidRegisterEvent(FluidRegistry.FluidRegisterEvent event) {
        LogHelper.info(event.fluidName);
        if (event.fluidName.equals("Steam")) {
            PowerConverters.steamId = event.fluidID;
        } else if (event.fluidName.equals("steam") && PowerConverters.steamId == -1) {
            PowerConverters.steamId = event.fluidID;
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("PowerConverters3")) {
            ConfigurationHandler.INSTANCE.loadConfiguration();
        }
    }

    @SideOnly(value=Side.SERVER)
    public void onClientJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!ConfigurationHandler.sendRecipesToClient) {
            LogHelper.trace("Recipe Sending is turned off.");
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        List<IRecipe> recipes = Recipes.getCurrentRecipes();
        NBTTagList tagList = new NBTTagList();
        for (IRecipe recipe : recipes) {
            NBTTagCompound tagCompound = IRecipeHandler.writeIRecipeToTag(recipe);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Recipes", (NBTBase)tagList);
        RecipeSyncPacket syncPacket = new RecipeSyncPacket(tag);
        PacketPipeline.INSTANCE.sendTo(syncPacket, (EntityPlayerMP)event.player);
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        ArrayList<ItemStack> currentOutputs = new ArrayList<ItemStack>();
        for (IRecipe recipe : Recipes.getCurrentRecipes()) {
            ItemStack stack = recipe.func_77571_b();
            currentOutputs.add(stack);
        }
        RecipeRemover.removeAnyRecipes(currentOutputs);
        for (IRecipe recipe : Recipes.getDefaultRecipes()) {
            CraftingManager.func_77594_a().func_77592_b().add(recipe);
        }
    }
}

