/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import com.google.common.base.Objects;
import openmods.calc.FixedSymbol;
import openmods.calc.ICalculatorFrame;

public class Constant<E>
extends FixedSymbol<E> {
    private final E value;

    public Constant(E value) {
        super(0, 1);
        this.value = value;
    }

    @Override
    public void execute(ICalculatorFrame<E> frame) {
        frame.stack().push(this.value);
    }

    public static <E> Constant<E> create(E value) {
        return new Constant<E>(value);
    }

    public boolean equals(Object other) {
        return other instanceof Constant && Objects.equal(((Constant)other).value, this.value);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value});
    }

    public String toString() {
        return "Constant [value=" + this.value + "]";
    }
}

